package net.yura.grasshopper;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/**
 * @author Yura Mamyrin
 */
public class PopupBug extends Writer {

    static PopupBug instance;

    private JDialog errFrame;
    private JTextArea debugText;
    private BugManager simplePrintStream;
    private String cause;

    private PopupBug() {

        debugText = new JTextArea();
        debugText.setEditable(false);

        simplePrintStream = new BugManager() {
            protected void action(String thecause) {
                cause = thecause;
                openPopup();
            }
        };
        
        BugManager.interceptAndAlert(this, simplePrintStream );

        instance = this;
    }


    public static void initSimple(String appname,String version,String locale) {
        if (instance==null) {
            new PopupBug();
        }

        BugSystemInfo.appName = appname;
        BugSystemInfo.version = version;
        BugSystemInfo.locale = locale;
    }

    public static void log(String text) {
        instance.debugText.append(text);
    }
    public static void clearLog() {
        if (!instance.simplePrintStream.hasHappened()) { // only clear is nothing has happened
            instance.debugText.setText("");
        }
    }

    private void openPopup() {

        // only create all this stuff if an error has happened
        if (errFrame==null) {

            //errFrame = new JFrame("an error has occurred!!!");
            
            // if we use a frame or a none-model dialog and we alredy have a [Frame->ModelDialog] open, we cant access this window
            errFrame = new JDialog((JFrame)null,"an error has occurred!!!",true);

            //errFrame.setDefaultCloseOperation( JFrame.DO_NOTHING_ON_CLOSE );
            errFrame.addWindowListener(new java.awt.event.WindowAdapter() {
                public void windowClosing(WindowEvent winEvt) {
                    errFrame.setVisible(false);
                    doSubmit("closed");
                }
            });

            JScrollPane errScroll = new JScrollPane(debugText);

            Dimension size = new Dimension(400,400);

            errScroll.setMaximumSize(size);
            errScroll.setPreferredSize(size);
            errScroll.setMinimumSize(size);

            JLabel label = new JLabel("an error happened, please click on the button at the bottom to send it");
            label.setBorder( BorderFactory.createMatteBorder(10,10,10,10,Color.RED) );

            JButton saveErr = new JButton("click here to send");

            saveErr.addActionListener(
                new ActionListener() {
                    public void actionPerformed(ActionEvent a) {
                            String email = JOptionPane.showInputDialog(errFrame,"tell me your e-mail please, in case i have questons about this bug");
                            if (email == null) { email ="not-given"; }
                            errFrame.setVisible(false);
                            try {
                                doSubmit(email);
                                JOptionPane.showMessageDialog(null, "SENT!");
                            }
                            catch(Throwable ex) {
                                JOptionPane.showMessageDialog(null, "ERROR: "+ex.getMessage() );
                            }
                    }
                }
            );

            errFrame.getContentPane().add( label , BorderLayout.NORTH );
            errFrame.getContentPane().add( errScroll , BorderLayout.CENTER);
            errFrame.getContentPane().add( saveErr , BorderLayout.SOUTH);

            errFrame.pack();

        }

        errFrame.setVisible(true);
    }

    private void doSubmit(String email) {
        BugSubmitter.submitBug(debugText.getText(),email,cause);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        debugText.append(String.valueOf(cbuf, off, len));
    }

    public void flush() { }
    public void close() { }

/*

    JFileChooser fc = new JFileChooser();
    RiskFileFilter filter = new RiskFileFilter(RiskFileFilter.RISK_LOG_FILES);
    fc.setFileFilter(filter);

    int returnVal = fc.showSaveDialog(errFrame);
    if (returnVal == JFileChooser.APPROVE_OPTION) {
            java.io.File file = fc.getSelectedFile();
            // Write your code here what to do with selected file

            String fileName = file.getAbsolutePath();

            if (!(fileName.endsWith( "." + RiskFileFilter.RISK_LOG_FILES ))) {
                    fileName = fileName + "." + RiskFileFilter.RISK_LOG_FILES;
            }

            try {

                    FileWriter fileout = new FileWriter(fileName);
                    BufferedWriter buffer = new BufferedWriter(fileout);
                    PrintWriter printer = new PrintWriter(buffer);

                    printer.write(debugText.getText());

                    printer.close();

            }

            catch(Exception error) {
                    JOptionPane.showMessageDialog(errFrame, "unable to save file: " + error.getMessage(), "save error", JOptionPane.ERROR_MESSAGE);
            }

    } else {
            // Write your code here what to do if user has canceled Save dialog
    }

*/

}
