package net.yura.grasshopper;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Field;
import android.graphics.Bitmap;
import android.graphics.Bitmap.CompressFormat;
import android.graphics.Canvas;
import android.view.View;

public class BugUIInfo {


    public static String getLookAndFeel() {

//      PackageInfo packageInfo = getPackageManager().getPackageInfo(getPackageName(), PackageManager.GET_META_DATA);
//      int themeResId = packageInfo.applicationInfo.theme;
//      return getResources().getResourceEntryName(themeResId);
        
        return "Android";
    }
    
    public static byte[][] getFrames() {
        
        View[] windows = getAllFrames();
        byte[][] images = new byte[windows.length][];
        
        for (int i=0;i<windows.length;i++) {
            View v = windows[i];
            int w = v.getWidth();
            int h = v.getHeight();
            // for unknown reason w or h can be lass then 0
            Bitmap b = Bitmap.createBitmap( w>0?w:10, h>0?h:10, Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(b);
            v.draw(c);

            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            /* Write bitmap to file using JPEG or PNG and 80% quality hint for JPEG. */
            b.compress(CompressFormat.PNG, 80, stream);
            images[i] = stream.toByteArray();
        }

        return images;
    }

    /**
     * copy-paste from Robotium and AndroidRemoteTest
     */
    public static View[] getAllFrames() {
        try {
            Class windowManager = Class.forName("android.view.WindowManagerImpl");

            Field viewsField = windowManager.getDeclaredField("mViews");
            viewsField.setAccessible(true);

            String wndManStr = (android.os.Build.VERSION.SDK_INT >= 13) ? "sWindowManager" : "mWindowManager";
            Field instanceField = windowManager.getDeclaredField(wndManStr);
            instanceField.setAccessible(true);

            Object instance = instanceField.get(null);
            return (View[]) viewsField.get(instance);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}
