package net.yura.grasshopper;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;

/**
 * @author Yura Mamyrin
 */
public class BugSubmitter {

    /**
     * internal methods used by SimpleBug
     */
    static void submitBug(Object log,String cause) {
        submitBug(log, "no-email", cause);
    }

    /**
     * internal method used by PopupBug
     */
    static void submitBug(Object log, String email, String cause) {
        submitBug(log, email, BugSystemInfo.appName+" "+BugSystemInfo.version +" "+BugSystemInfo.locale+" Bug",cause,
                BugSystemInfo.appName, BugSystemInfo.version, BugSystemInfo.locale
                );
    }

    /**
     * public method for submitting a bug or anything else
     */
    public static void submitBug(Object log, String email,String subject,String cause,
            String appName, String version, String locale
            ) {
        Hashtable map = new Hashtable();
        map.put("log", log);

        map.put("appName", appName);
        map.put("appVersion", version);
        map.put("appLocale", locale);
        
        map.put("grasshopperVersion", BugManager.VER);

        map.putAll( BugSystemInfo.addSystemInfo() );

        map.put("recipient","yura@yura.net");
        map.put("subject","GRASSHOPPER "+subject);
        map.put("email",email);
        map.put("env_report","REMOTE_HOST,HTTP_USER_AGENT");
        
        if (cause!=null) {
            map.put("cause",cause);
        }
        
        try {
            BugSubmitterMultipart.send("http://yura.net/cgi-bin/TFmail.cgi", map);
            System.out.println("[grasshopper] send ok");
        }
        catch (Throwable th) {
            try {
                
                StringWriter error = new StringWriter();
                th.printStackTrace( new PrintWriter(error) );
                map.put("grasshopperError", error.toString() );
                
                doPost("http://yura.net/cgi-sys/FormMail.cgi", map);
                System.out.println("[grasshopper] send ok ish "+th);
            }
            catch(Throwable th2) {
                System.out.println("[grasshopper] error sending: "+th+" "+th2);
            }
        }
    }

    public static void doPost(OutputStreamWriter getpostb,Hashtable map) throws IOException {

            boolean firstDone=false;

            Enumeration enu = map.keys();
            while(enu.hasMoreElements()) {
                
                if (firstDone) {
                    getpostb.append("&");
                }
                else {
                    firstDone = true;
                }
                
                Object key = enu.nextElement();
                getpostb.append( URLEncoder.encode( String.valueOf( key ) , "UTF-8") );

                getpostb.append("=");

                Object object = map.get(key);
                if (object instanceof File) {
                    
                    BufferedReader br = new BufferedReader(new FileReader( (File)object ));
                    String line;
                    while((line = br.readLine()) != null) {
                         getpostb.append( URLEncoder.encode( line+"<br>\n" , "UTF-8") );
                    }

                }
                else {
                    String value = String.valueOf( object );
                    value = value.replaceAll("\\n|\\r\\n", "<br>$0"); // add <br> to the end of every line
                    getpostb.append( URLEncoder.encode( value , "UTF-8"));
                }
            }

    }


    public static void doPost(String url, Hashtable map) throws IOException {

            	URLConnection conn = new URL(url).openConnection();
        	conn.setDoOutput(true);
        	OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());

        	doPost(wr,map);

        	wr.close();

        	// Get the response
                //StringBuffer buffer = new StringBuffer();
        	BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        	String line;
        	while ((line = rd.readLine()) != null) {
		//	buffer.append(line);
                //        buffer.append("\n");
        	}

        	rd.close();
		//return buffer.toString();
                // do NOT read the responce into a buffer, as we do not need it anyway
    }

}
