/*
 * Decompiled with CFR 0.152.
 */
package net.yura.translation.plugins;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.yura.translation.MessageTool;
import net.yura.translation.Mtcomm;
import net.yura.translation.MyNode;
import net.yura.translation.PartnerNode;
import net.yura.translation.Result;

public class PropertiesComm
implements Mtcomm {
    private Properties props;
    private HashMap map;
    private String name;
    private String extension;
    private File myDir = new File("risk/engine/translation");

    public boolean load() throws Exception {
        JFileChooser fc = new JFileChooser(this.myDir);
        this.setupFilter(fc);
        fc.setFileSelectionMode(0);
        int returnVal = fc.showDialog(null, "Select");
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.load(file);
            return true;
        }
        return false;
    }

    public void load(File file) throws Exception {
        this.myDir = file.getParentFile();
        this.props = this.load(new FileInputStream(file));
        this.map = new HashMap();
        this.name = file.getPath();
        this.extension = this.name.substring(this.name.lastIndexOf(46), this.name.length());
        this.name = this.name.substring(0, this.name.lastIndexOf(46));
    }

    public void setupFilter(JFileChooser fc) {
        FileFilter ff = new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".properties");
            }

            public String getDescription() {
                return "Java Properties Files (*.properties)";
            }
        };
        fc.addChoosableFileFilter(ff);
        fc.setFileFilter(ff);
    }

    public Properties load(FileInputStream in) throws Exception {
        Properties p = new Properties();
        p.load(in);
        return p;
    }

    public void store(final Properties p, FileOutputStream out, final String a) throws Exception {
        final PipedOutputStream pout = new PipedOutputStream();
        PipedInputStream pin = new PipedInputStream(pout);
        final Vector errors = new Vector();
        new Thread(){

            public void run() {
                try {
                    p.store(pout, a);
                    pout.close();
                }
                catch (Throwable ex) {
                    errors.add(ex);
                }
            }
        }.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(pin));
        String input = reader.readLine();
        Vector<String> lines = new Vector<String>();
        while (input != null) {
            lines.add(input);
            input = reader.readLine();
        }
        Collections.sort(lines);
        BufferedWriter bufferout = new BufferedWriter(new OutputStreamWriter(out));
        for (int c = 0; c < lines.size(); ++c) {
            bufferout.write((String)lines.elementAt(c));
            bufferout.newLine();
        }
        bufferout.close();
        if (!errors.isEmpty()) {
            throw new Exception((Throwable)errors.firstElement());
        }
    }

    public void addChildren(MyNode node) {
        String name = node.getName();
        if (name.length() > 0) {
            name = name + ".";
        }
        Enumeration<?> en = this.props.propertyNames();
        while (en.hasMoreElements()) {
            String s = en.nextElement().toString();
            if (!s.startsWith(name)) continue;
            s = s.substring(name.length(), s.length());
            boolean children = false;
            boolean message = false;
            if (s.indexOf(46) != -1) {
                children = true;
                s = s.substring(0, s.indexOf(46));
            } else {
                message = true;
            }
            MyNode newnode = new MyNode(s, message, children);
            node.add(newnode);
        }
    }

    public String getMessage(MyNode node, PartnerNode partner, Locale l) {
        return this.getLocaleProperties(l).getProperty(node.getName());
    }

    public Properties getLocaleProperties(Locale l) {
        if (l == null) {
            return this.props;
        }
        if (!this.map.containsKey(l)) {
            Properties pp;
            try {
                pp = this.load(new FileInputStream(new File(this.name + "_" + l + this.extension)));
            }
            catch (Exception e) {
                pp = new Properties();
                System.out.println("not found: " + l);
            }
            this.map.put(l, pp);
        }
        return (Properties)this.map.get(l);
    }

    public String toString() {
        return "Risk Language Plugin\nBy Yura Mamyrin (yura@yura.net)\nRisk site: http://jrisk.sf.net/";
    }

    public void saveMessage(MyNode node, PartnerNode part, Locale l, String message) throws Exception {
        Properties p = this.getLocaleProperties(l);
        if (message == null) {
            p.remove(node.getName());
        } else {
            p.setProperty(node.getName(), message);
        }
        FileOutputStream fos = new FileOutputStream(this.name + (l == null ? "" : "_" + l) + this.extension);
        this.store(p, fos, "yura.net Translation Tool 2.7");
    }

    public Locale[] getLocales() {
        Locale[] a = Locale.getAvailableLocales();
        Arrays.sort(a, MessageTool.CASE_POSTERIORITY_ORDER);
        return a;
    }

    public Result[] search(String s) throws Exception {
        Locale[] mylocs = Locale.getAvailableLocales();
        Vector<Result> results = new Vector<Result>();
        if (s != null) {
            s = s.toLowerCase();
            this.findString(null, this.props, s, results);
            for (int c = 0; c < mylocs.length; ++c) {
                this.findString(mylocs[c], this.getLocaleProperties(mylocs[c]), s, results);
            }
        } else {
            Enumeration<Object> it = this.props.keys();
            while (it.hasMoreElements()) {
                String key = (String)it.nextElement();
                for (int c = 0; c < mylocs.length; ++c) {
                    Properties p = this.getLocaleProperties(mylocs[c]);
                    if (p.size() == 0 || p.get(key) != null) continue;
                    Result res = new Result();
                    res.node = key;
                    res.locale = mylocs[c];
                    results.add(res);
                }
            }
        }
        return results.toArray(new Result[results.size()]);
    }

    private void findString(Locale l, Properties p, String s, Vector r) {
        Iterator<Map.Entry<Object, Object>> it = p.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> me = it.next();
            String key = (String)me.getKey();
            String value = (String)me.getValue();
            if (value.toLowerCase().indexOf(s) <= -1) continue;
            Result res = new Result();
            res.node = key;
            res.locale = l;
            r.add(res);
        }
    }

    public void setupMissingTranslation(MyNode node, Locale l) throws Exception {
        String realname = node.getName();
        String name = node.getName();
        if (name.length() > 0) {
            name = name + ".";
        }
        Enumeration<Object> en = this.props.keys();
        Properties props2 = this.getLocaleProperties(l);
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!key.equals(realname) && !key.startsWith(name) || props2.containsKey(key)) continue;
            node.setWorkNeeded(true);
            return;
        }
        node.setWorkNeeded(false);
    }

    public PartnerNode[] getPartners() throws Exception {
        return new PartnerNode[]{new PartnerNode(0, "DEFAULT", null)};
    }
}

