/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import net.yura.mobile.io.BinUtil;
import net.yura.mobile.logging.Logger;

public class RMSUtil {
    public static void save(String name, Object vals) throws RecordStoreFullException, RecordStoreNotFoundException, RecordStoreException, IOException {
        try {
            RecordStore.deleteRecordStore((String)name);
        }
        catch (Exception ex) {
            Logger.info("can not del RMS, this should not happen");
            Logger.warn(ex);
        }
        RecordStore recordStore = RecordStore.openRecordStore((String)name, (boolean)true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RMSUtil.save(baos, vals);
        byte[] b = baos.toByteArray();
        recordStore.addRecord(b, 0, b.length);
        recordStore.closeRecordStore();
    }

    public static Object load(String name) throws RecordStoreFullException, RecordStoreNotFoundException, RecordStoreException, IOException {
        RecordEnumeration re;
        Object vals = null;
        RecordStore recordStore = RecordStore.openRecordStore((String)name, (boolean)true);
        if (recordStore.getNumRecords() != 0 && (re = recordStore.enumerateRecords(null, null, false)).hasNextElement()) {
            int id = re.nextRecordId();
            ByteArrayInputStream bais = new ByteArrayInputStream(recordStore.getRecord(id));
            if (vals != null) {
                System.err.println("vals already has a value: " + vals);
            }
            vals = RMSUtil.load(bais);
        }
        recordStore.closeRecordStore();
        return vals;
    }

    public static Object load(InputStream is) throws IOException {
        BinUtil util = new BinUtil();
        return util.load(is);
    }

    public static void save(OutputStream os, Object names) throws IOException {
        BinUtil util = new BinUtil();
        util.save(os, names);
    }
}

