/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.io;

import java.util.Hashtable;
import javax.microedition.location.Coordinates;
import javax.microedition.location.Criteria;
import javax.microedition.location.Location;
import javax.microedition.location.LocationException;
import javax.microedition.location.LocationProvider;
import javax.microedition.location.QualifiedCoordinates;
import net.yura.mobile.io.ServiceLink;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.Timer;

public abstract class LocationMonitor
implements ServiceLink.TaskHandler,
Runnable {
    public static final String COUNTRY_CODE_TYPE = "-1";
    public static final String NETWORK_CODE_TYPE = "-2";
    public static final String LOCATION_AREA_CODE_TYPE = "-3";
    public static final String SUBSCRIBER_IMSI_TYPE = "-4";
    public static final String SUBSCRIBER_HOME_COUNTRY_TYPE = "-5";
    static final int j2meCellPollRateInSeconds = 300;
    boolean bJ2MECellMonitorLoop = true;
    boolean bCellRequestMade = false;
    boolean bCellNotifyMade = false;
    Timer timer;
    static J2MECellMonitor j2MECellMonitor;

    public static J2MECellMonitor getJ2MECellMonitor() {
        if (j2MECellMonitor == null) {
            j2MECellMonitor = new J2MECellMonitor();
        }
        return j2MECellMonitor;
    }

    public synchronized void run() {
        try {
            ServiceLink link = ServiceLink.getInstance();
            if (link.isConnected()) {
                if (this.bJ2MECellMonitorLoop) {
                    this.setNotifyForCellId(this.bJ2MECellMonitorLoop);
                }
                this.bJ2MECellMonitorLoop = false;
            } else {
                this.putCellId(LocationMonitor.getJ2MECellMonitor().getJ2MECellId());
                if (this.bJ2MECellMonitorLoop) {
                    if (this.timer != null) {
                        this.timer.cancel();
                    }
                    this.timer = new Timer();
                    this.timer.schedule("J2MECellMonitor1", this, 300000L);
                }
            }
        }
        catch (Throwable t) {
            Logger.error(t);
        }
    }

    void putCellId(Hashtable hash) {
        if (hash != null) {
            ServiceLink.Task task = new ServiceLink.Task("PutCellId", hash);
            this.handleTask(task);
        }
    }

    public LocationMonitor() {
        ServiceLink link = ServiceLink.getInstance();
        link.registerForTask("PutCellId", this);
        link.registerForTask("GetCellIdError", this);
        link.registerForTask("PutWiFiSsList", this);
        link.registerForTask("GetWiFiSsListError", this);
    }

    public void getCellId() {
        ServiceLink link = ServiceLink.getInstance();
        if (!this.bCellRequestMade) {
            link.sendTask(new ServiceLink.Task("GetCellId", null));
            this.bCellRequestMade = true;
        }
        if (!link.isConnected()) {
            this.putCellId(LocationMonitor.getJ2MECellMonitor().getJ2MECellId());
        }
    }

    public void getWifiList() {
        ServiceLink link = ServiceLink.getInstance();
        link.sendTask(new ServiceLink.Task("GetWiFiSsList", null));
    }

    public void setNotifyForCellId(boolean b) {
        ServiceLink link = ServiceLink.getInstance();
        if (!this.bCellNotifyMade) {
            link.sendTask(new ServiceLink.Task("PutOptionCellIdPush", b ? Boolean.TRUE : Boolean.FALSE));
            this.bCellNotifyMade = true;
        }
        if (!link.isConnected()) {
            this.bJ2MECellMonitorLoop = b;
            if (b) {
                if (this.timer != null) {
                    this.timer.cancel();
                }
                this.timer = new Timer();
                this.timer.schedule("J2MECellMonitor2", this, 0L);
            }
        }
    }

    public void setNotifyForWifiList(boolean b) {
        ServiceLink link = ServiceLink.getInstance();
        link.sendTask(new ServiceLink.Task("PutOptionWiFiPush", b ? Boolean.TRUE : Boolean.FALSE));
    }

    public Coordinates getGPS() throws LocationException, InterruptedException {
        Criteria cr = new Criteria();
        cr.setHorizontalAccuracy(500);
        LocationProvider lp = LocationProvider.getInstance((Criteria)cr);
        Location l = lp.getLocation(300);
        QualifiedCoordinates c = l.getQualifiedCoordinates();
        if (c != null) {
            double lat = c.getLatitude();
            double lng = c.getLongitude();
            Logger.debug("lat:" + lat + " lng:" + lng);
        }
        return c;
    }

    public static class J2MECellMonitor {
        protected int cellPropertyIndex = this.getPropertyIndex(sysPropertyNames);
        protected int homeCountryPropertyIndex = -1;
        protected int mncPropertyIndex = -1;
        protected int signalPropertyIndex = -1;
        protected int locationAreaPropertyIndex = -1;
        protected int currentCountryPropertyIndex = this.getPropertyIndex(currentCountryPropertyNames);
        protected int imsiPropertyIndex = -1;
        static final String[] sysPropertyNames = new String[]{"CellID", "Cell-ID", "CELLID", "Cell ID", "ID", "Cellid", "CellID", "phone.cid", "com.nokia.mid.cellid", "com.sonyericsson.net.cellid", "phone.cid", "com.samsung.cellid", "com.siemens.cellid", "cid"};
        static final String[] currentCountryPropertyNames = new String[]{"com.nokia.mid.countrycode", "com.sonyericsson.net.cmcc", "com.sonyericsson.net.mcc", "cmcc", "CMCC", "mcc", "MCC"};
        static final String[] homeCountryPropertyNames = new String[]{"com.nokia.mid.countrycode", "com.sonyericsson.net.mcc", "mcc", "MCC"};
        static final String[] mncPropertyNames = new String[]{"com.sonyericsson.net.cmnc", "com.nokia.mid.networkid", "phone.mnc", "mnc", "MNC"};
        static final String[] signalPropertyNames = new String[]{"com.nokia.mid.networksignal", "NETWORKSIGNAL"};
        static final String[] locationAreaPropertyNames = new String[]{"com.nokia.mid.lac", "com.sonyericsson.net.lac", "LAC", "LocAreaCode", "phone.lac"};
        static final String[] imsiPropertyNames = new String[]{"com.nokia.mid.imsi", "com.sonyericsson.sim.subscribernumber", "IMSI"};
        String j2mePreviousCell = "UNSET";

        public J2MECellMonitor() {
            this.homeCountryPropertyIndex = this.getPropertyIndex(homeCountryPropertyNames);
            this.mncPropertyIndex = this.getPropertyIndex(mncPropertyNames);
            this.signalPropertyIndex = this.getPropertyIndex(signalPropertyNames);
            this.locationAreaPropertyIndex = this.getPropertyIndex(locationAreaPropertyNames);
            this.imsiPropertyIndex = this.getPropertyIndex(imsiPropertyNames);
        }

        private int getPropertyIndex(String[] properties) {
            for (int index = 0; index < properties.length; ++index) {
                try {
                    String property = System.getProperty(properties[index]);
                    if (property == null || property.length() <= 0) continue;
                    return index;
                }
                catch (Exception t) {
                    Logger.warn(t);
                }
            }
            return -1;
        }

        private String getProperty(int index, String[] array) {
            if (index >= 0) {
                return System.getProperty(array[index]);
            }
            return null;
        }

        public String getCellIdProperty() {
            return this.getProperty(this.cellPropertyIndex, sysPropertyNames);
        }

        public String getSignalProperty() {
            String signal = this.getProperty(this.signalPropertyIndex, signalPropertyNames);
            if (signal == null) {
                signal = "0";
            }
            return signal;
        }

        public String getLocationAreaProperty() {
            return this.getProperty(this.locationAreaPropertyIndex, locationAreaPropertyNames);
        }

        public String getImsiProperty() {
            return this.getProperty(this.imsiPropertyIndex, imsiPropertyNames);
        }

        public String getMncProperty() {
            return this.getProperty(this.mncPropertyIndex, mncPropertyNames);
        }

        public String getHomeCountryProperty() {
            return this.getProperty(this.homeCountryPropertyIndex, homeCountryPropertyNames);
        }

        public String getCurrentCountryProperty() {
            return this.getProperty(this.currentCountryPropertyIndex, currentCountryPropertyNames);
        }

        protected Hashtable getJ2MECellId() {
            try {
                String cell = this.getCellIdProperty();
                if (cell != null && !cell.equals(this.j2mePreviousCell)) {
                    Hashtable<String, String> hash = new Hashtable<String, String>(6);
                    String signal = this.getSignalProperty();
                    hash.put(cell, signal);
                    this.addPropertyToHash(hash, this.getCurrentCountryProperty(), LocationMonitor.COUNTRY_CODE_TYPE);
                    this.addPropertyToHash(hash, this.getMncProperty(), LocationMonitor.NETWORK_CODE_TYPE);
                    this.addPropertyToHash(hash, this.getLocationAreaProperty(), LocationMonitor.LOCATION_AREA_CODE_TYPE);
                    this.addPropertyToHash(hash, this.getImsiProperty(), LocationMonitor.SUBSCRIBER_IMSI_TYPE);
                    this.addPropertyToHash(hash, this.getHomeCountryProperty(), LocationMonitor.SUBSCRIBER_HOME_COUNTRY_TYPE);
                    this.j2mePreviousCell = cell;
                    return hash;
                }
            }
            catch (Exception t) {
                Logger.warn(t);
            }
            return null;
        }

        private void addPropertyToHash(Hashtable values, String value, Object key) {
            if (value != null) {
                values.put(value, key);
            }
        }
    }
}

