/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import java.util.Vector;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.cellrenderer.ListCellRenderer;
import net.yura.mobile.gui.cellrenderer.MenuItemRenderer;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Frame;
import net.yura.mobile.gui.components.List;
import net.yura.mobile.gui.components.Menu;
import net.yura.mobile.gui.components.Window;

public class MenuBar
extends List
implements ActionListener {
    MenuBar owner;
    private int cols;
    private Border divider;
    private Border verticalDivider;

    public MenuBar() {
        this.setLayoutOrientation(3);
        this.setCellRenderer(new MenuItemRenderer());
        this.setActionCommand("activate");
        this.addActionListener(this);
    }

    public boolean processKeyEvent(KeyEvent keyEvent) {
        if (this.getLayoutOrientation() == 0 && this.getSelectedValue() instanceof Menu && keyEvent.justPressedAction(5)) {
            this.fireActionPerformed();
            return true;
        }
        return super.processKeyEvent(keyEvent);
    }

    public boolean isVisible() {
        if (this.getDesktopPane().SOFT_KEYS && this.isFrameMenuBar() && !((Frame)this.getWindow()).isMaximum()) {
            return false;
        }
        return super.isVisible();
    }

    public String getDefaultName() {
        return "MenuBar";
    }

    public void addImpl(Component button, Object cons, int index) {
        if (this.getItems().contains(button)) {
            throw new RuntimeException("can not add the same button twice: " + button);
        }
        super.addImpl(button, cons, index);
        if (index == -1) {
            super.addElement(button);
        } else {
            this.setSelectedIndex(-1);
            this.getItems().insertElementAt(button, index);
        }
        if (this.isFrameMenuBar() && button instanceof Button) {
            this.autoMnemonic();
        }
        if (button instanceof Button && button.getName().equals("Button")) {
            ((Button)button).setName("MenuItem");
            ((Button)button).setHorizontalAlignment(4);
        }
    }

    void autoMnemonic() {
        if (this.getSize() > 0 && this.getElementAt(0) instanceof Menu && ((Button)this.getElementAt(0)).getMnemonic() == 0) {
            ((Button)this.getElementAt(0)).setMnemonic(-12);
        }
    }

    public void removeAll() {
        while (super.getSize() > 0) {
            this.remove((Component)super.getElementAt(super.getSize() - 1));
        }
    }

    public void remove(Component c) {
        this.setSelectedIndex(-1);
        this.getItems().removeElement(c);
        c.removeParent(this);
    }

    public boolean removeElement(Object obj) {
        throw new RuntimeException("do not use this as it will fail on removing non-visible components, use remove() instead");
    }

    public void addElement(Object a) {
        throw new RuntimeException("do not use this as it will fail, use add() instead");
    }

    public void actionPerformed(String actionCommand) {
        if ("activate".equals(actionCommand)) {
            int index = this.getSelectedIndex();
            if (index >= 0) {
                Button button = (Button)this.getElementAt(index);
                Component comp = this.getRendererComponentFor(index);
                button.setBoundsWithBorder(comp.getXWithBorder(), comp.getYWithBorder(), comp.getWidthWithBorder(), comp.getHeightWithBorder());
                if (!(button instanceof Menu)) {
                    this.actionPerformed("close");
                }
                button.fireActionPerformed();
            }
        } else if ("close".equals(actionCommand)) {
            Window w;
            this.setSelectedIndex(-1);
            if (this.isFrameMenuBar() && (w = this.getWindow()).getFocusOwner() == this) {
                w.setFocusedComponent(null);
            }
            Window win = this.getWindow();
            if (win.closeOnFocusLost) {
                win.setVisible(false);
            }
            if (this.owner != null) {
                this.owner.actionPerformed("close");
            }
        } else {
            super.actionPerformed(actionCommand);
        }
    }

    public Button findMneonicButton(int mnu) {
        Vector items = this.getItems();
        for (int i = 0; i < items.size(); ++i) {
            Button button1;
            Object component = items.elementAt(i);
            if (!(component instanceof Button)) continue;
            Button button = (Button)component;
            if (button.getMnemonic() == mnu) {
                if (button.isVisible()) {
                    Component comp = this.getRendererComponentFor(this.indexOf(button));
                    button.setBoundsWithBorder(comp.getXWithBorder(), comp.getYWithBorder(), comp.getWidthWithBorder(), comp.getHeightWithBorder());
                }
                return button;
            }
            if (!(component instanceof Menu) || (button1 = ((Menu)component).findMneonicButton(mnu)) == null) continue;
            return button1;
        }
        return null;
    }

    public void setSelectedIndex(int a) {
        if (a >= 0) {
            Component c;
            int current = this.getSelectedIndex();
            while ((c = (Component)this.getElementAt(a)) != null && !c.isFocusable()) {
                if (current > a) {
                    --a;
                    continue;
                }
                if (current >= a) continue;
                ++a;
            }
            if (c == null) {
                a = current;
            }
        }
        super.setSelectedIndex(a);
    }

    public void paintComponent(Graphics2D g) {
        DesktopPane dp = this.getDesktopPane();
        int off = 0;
        if (dp.SOFT_KEYS && this.isFrameMenuBar()) {
            Button b2;
            Button b1 = dp.getSelectedFrame().findMnemonicButton(-6);
            if (b1 != null) {
                off = b1.getWidthWithBorder();
            }
            if ((b2 = dp.getSelectedFrame().findMnemonicButton(-12)) != null) {
                off = b2.getWidthWithBorder();
            }
            if (dp.isSideSoftKeys()) {
                int minWidth = 0;
                ListCellRenderer renderer = this.getCellRenderer();
                int current = this.getSelectedIndex();
                int size = this.getSize();
                for (int i = 0; i < size; ++i) {
                    Object item = this.getElementAt(i);
                    Component c = renderer.getListCellRendererComponent(this, item, i, i == current, false);
                    c.workoutPreferredSize();
                    minWidth += c.getWidthWithBorder();
                }
                off = this.width - off - minWidth;
            }
        }
        g.translate(off, 0);
        super.paintComponent(g);
        g.translate(-off, 0);
        this.paintDividers(g);
    }

    private boolean isFrameMenuBar() {
        Window w = this.getWindow();
        return w instanceof Frame && ((Frame)w).getMenuBar() == this;
    }

    public Object getElementAt(int index) {
        Vector items = this.getItems();
        int count = 0;
        for (int c = 0; c < items.size(); ++c) {
            if (!((Component)items.elementAt(c)).isVisible()) continue;
            if (count == index) {
                return items.elementAt(c);
            }
            ++count;
        }
        return null;
    }

    public int getSize() {
        Vector items = this.getItems();
        int count = 0;
        for (int c = 0; c < items.size(); ++c) {
            if (!((Component)items.elementAt(c)).isVisible()) continue;
            ++count;
        }
        return count;
    }

    private boolean firstMenu() {
        return this.owner != null && this.owner.isFrameMenuBar();
    }

    protected Component getComponentFor(int i, int offset) {
        Component c = super.getComponentFor(i, offset);
        if (this.getDesktopPane().GRID_MENU && this.firstMenu()) {
            int mycols;
            int ypos;
            int size = this.getSize();
            int topRowCols = size % this.cols;
            int h = (this.getHeight() + this.getDividerHeight()) / (size / this.cols + (topRowCols == 0 ? 0 : 1));
            if (i < topRowCols) {
                ypos = 0;
                mycols = topRowCols;
            } else {
                int x = i - topRowCols;
                i = x % this.cols;
                mycols = this.cols;
                ypos = h * (x / this.cols) + (topRowCols == 0 ? 0 : h);
            }
            int w = (this.getWidth() + this.getDividerWidth()) / mycols;
            int widthMinusDiv = i == mycols - 1 ? this.getWidth() - w * i : w - this.getDividerWidth();
            int heightMinusDiv = h - this.getDividerHeight();
            c.setBoundsWithBorder(w * i, ypos, widthMinusDiv, heightMinusDiv);
        }
        return c;
    }

    protected void workoutMinimumSize() {
        DesktopPane dp = this.getDesktopPane();
        if (dp.SOFT_KEYS && this.isFrameMenuBar()) {
            boolean focus = false;
            int size = this.getSize();
            for (int i = 0; i < size; ++i) {
                Component item = (Component)this.getElementAt(i);
                if (!item.isFocusable()) continue;
                focus = true;
                break;
            }
            this.focusable = focus;
        }
        if (dp.GRID_MENU) {
            int size = this.getSize();
            ListCellRenderer renderer = this.getCellRenderer();
            int w = 0;
            int h = 0;
            boolean icon = false;
            for (int i = 0; i < size; ++i) {
                Object item = this.getElementAt(i);
                if (item instanceof Button) {
                    Button button = (Button)item;
                    if (this.firstMenu()) {
                        button.setHorizontalAlignment(1);
                        button.setVerticalAlignment(2);
                        button.setHorizontalTextPosition(1);
                        button.setVerticalTextPosition(32);
                    }
                    if (button.getIcon() != null) {
                        icon = true;
                    }
                }
                Component c = renderer.getListCellRendererComponent(this, item, i, false, false);
                c.workoutPreferredSize();
                if (w < c.getWidthWithBorder()) {
                    w = c.getWidthWithBorder();
                }
                if (h >= c.getHeightWithBorder()) continue;
                h = c.getHeightWithBorder();
            }
            if (!icon) {
                h += h / 2;
            }
            if (w < h) {
                w = h;
            }
            this.setFixedCellHeight(h == 0 ? -1 : h);
            this.setFixedCellWidth(w == 0 ? -1 : w);
            if (this.firstMenu()) {
                this.getWindow().setName("AndroidMenu");
                this.setLayoutOrientation(-1);
                int in = 0;
                for (Component p = this; p != null; p = p.getParent()) {
                    in = p.getInsets().getRight() + p.getInsets().getLeft();
                }
                this.width = dp.getWidth() - in;
                this.cols = Math.max(Math.min((this.width + this.getDividerWidth()) / (w + this.getDividerWidth()), size), 1);
                int rows = size / this.cols + (size % this.cols == 0 ? 0 : 1);
                this.cols = size / rows + (size % rows == 0 ? 0 : 1);
                this.height = h * rows + (rows - 1) * this.getDividerHeight();
                return;
            }
        }
        super.workoutMinimumSize();
    }

    protected void paintDividers(Graphics2D g) {
        int size = this.getSize();
        if (size == 0) {
            return;
        }
        int rows = size;
        if (this.getDesktopPane().GRID_MENU && this.firstMenu()) {
            int topRowCols = size % this.cols;
            rows = size / this.cols + (topRowCols == 0 ? 0 : 1);
            if (this.verticalDivider != null) {
                int y;
                int x;
                int c;
                int w;
                int topRowHeight = 0;
                if (topRowCols > 0) {
                    topRowHeight = this.getHeight() / rows;
                    w = (this.getWidth() + this.getDividerWidth()) / topRowCols;
                    for (c = 1; c < topRowCols; ++c) {
                        x = c * w;
                        y = this.verticalDivider.getLeft();
                        g.translate(x, y);
                        this.verticalDivider.paintBorder(this, g, 0, topRowHeight);
                        g.translate(-x, -y);
                    }
                }
                w = (this.getWidth() + this.getDividerWidth()) / this.cols;
                for (c = 1; c < this.cols; ++c) {
                    x = c * w;
                    y = topRowHeight + this.verticalDivider.getLeft();
                    g.translate(x, y);
                    this.verticalDivider.paintBorder(this, g, 0, this.getHeight() - topRowHeight);
                    g.translate(-x, -y);
                }
            }
        }
        if (this.divider != null) {
            int h = (this.getHeight() + this.getDividerHeight()) / rows;
            for (int c = 1; c < rows; ++c) {
                int x = this.divider.getLeft();
                int y = c * h;
                g.translate(x, y);
                this.divider.paintBorder(this, g, this.width, 0);
                g.translate(-x, -y);
            }
        }
    }

    private int getDividerHeight() {
        return this.divider != null ? this.divider.getTop() : 0;
    }

    private int getDividerWidth() {
        return this.verticalDivider != null ? this.verticalDivider.getLeft() : 0;
    }

    public void updateUI() {
        super.updateUI();
        this.divider = (Border)this.theme.getProperty("divider", 0);
        this.verticalDivider = (Border)this.theme.getProperty("verticalDivider", 0);
    }
}

