/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.psi.j2se.rms;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Vector;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordListener;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;
import org.me4se.impl.rms.AbstractRecordStore;

public class RecordStoreImpl
extends AbstractRecordStore {
    int version = 0;
    long lastModified = 0L;
    static final byte[] RECORD_INVALID = new byte[0];
    Vector records;
    File file;
    public static File rmsDir = null;
    private static final Vector todo = new Vector();

    public static String decode(String query) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < query.length(); ++i) {
            if (query.charAt(i) == '(') {
                int cut = query.indexOf(41, i + 1);
                while (true) {
                    int c2;
                    if ((c2 = query.indexOf(45, i + 1)) == -1 || c2 >= cut) {
                        c2 = cut;
                    }
                    int code = Integer.parseInt(query.substring(i + 1, c2), 36);
                    sb.append((char)code);
                    if (c2 == cut) break;
                    i = c2;
                }
                i = cut;
                continue;
            }
            sb.append(query.charAt(i));
        }
        return sb.toString();
    }

    public static String encode(String query) {
        StringBuffer sb = new StringBuffer();
        boolean pending = false;
        for (int i = 0; i < query.length(); ++i) {
            char c = query.charAt(i);
            if (c == '-' || c == '_' || c == '.' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                if (pending) {
                    sb.append(')');
                    pending = false;
                }
                sb.append(c);
                continue;
            }
            String uc = Integer.toString(c, 36);
            sb.append(pending ? (char)'-' : '(');
            sb.append(uc);
            pending = true;
        }
        if (pending) {
            sb.append(')');
        }
        return sb.toString();
    }

    boolean isApplet() {
        return rmsDir == null;
    }

    private void changeVersion() {
        ++this.version;
        this.lastModified = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile() throws RecordStoreException {
        if (this.isApplet()) {
            return;
        }
        if (this.file == null) {
            return;
        }
        Vector vector = todo;
        synchronized (vector) {
            if (!todo.contains(this)) {
                todo.add(this);
                todo.notifyAll();
            }
        }
    }

    private void doWriteToFile() throws Exception {
        DataOutputStream dos;
        try {
            dos = new DataOutputStream(new FileOutputStream(this.file));
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            System.out.println("this is prob the windows bug, so trying again...");
            Thread.yield();
            System.gc();
            try {
                Thread.sleep(1000L);
            }
            catch (Throwable th) {
                // empty catch block
            }
            dos = new DataOutputStream(new FileOutputStream(this.file));
        }
        dos.writeInt(this.version);
        dos.writeLong(this.lastModified);
        int cnt = this.records.size();
        dos.writeInt(cnt);
        for (int i = 0; i < cnt; ++i) {
            Object obj = this.records.elementAt(i);
            if (obj == RECORD_INVALID) {
                dos.writeInt(-2);
                continue;
            }
            if (obj == null) {
                dos.writeInt(-1);
                continue;
            }
            byte[] buffer = (byte[])obj;
            dos.writeInt(buffer.length);
            dos.write(buffer, 0, buffer.length);
        }
        dos.flush();
        dos.close();
    }

    public void open(String recordStoreName, boolean create) throws RecordStoreException {
        ++this.refCount;
        if (this.records != null) {
            return;
        }
        this.recordStoreName = recordStoreName;
        if (this.isApplet()) {
            if (!create) {
                this.refCount = 0;
                throw new RecordStoreNotFoundException();
            }
            this.records = new Vector();
        } else {
            try {
                if (!rmsDir.isDirectory() && !rmsDir.mkdirs()) {
                    throw new RuntimeException("mkdirs returned false for: " + rmsDir);
                }
            }
            catch (Throwable th) {
                rmsDir = null;
                if (!create) {
                    this.refCount = 0;
                    RecordStoreNotFoundException ex = new RecordStoreNotFoundException();
                    ex.initCause(th);
                    throw ex;
                }
                this.records = new Vector();
                return;
            }
            this.file = new File(rmsDir, RecordStoreImpl.encode(this.recordStoreName) + ".rms");
            int count = -1;
            int length = -1;
            int i = -1;
            this.records = new Vector();
            try {
                DataInputStream dis = new DataInputStream(new FileInputStream(this.file));
                this.version = dis.readInt();
                this.lastModified = dis.readLong();
                count = dis.readInt();
                for (i = 0; i < count; ++i) {
                    length = dis.readInt();
                    if (length >= 0) {
                        byte[] buffer = new byte[length];
                        dis.readFully(buffer, 0, length);
                        this.records.addElement(buffer);
                        continue;
                    }
                    if (length == -2) {
                        this.records.addElement(RECORD_INVALID);
                        continue;
                    }
                    if (length != -1) continue;
                    this.records.addElement(null);
                }
                dis.close();
            }
            catch (Throwable ioe) {
                if (!(ioe instanceof FileNotFoundException)) {
                    System.err.println("Exception while reading RMS: " + this.file + " version=" + this.version + " lastModified=" + this.lastModified + " count=" + count + " record=" + i + " length=" + length);
                    ioe.printStackTrace();
                }
                if (!create) {
                    this.refCount = 0;
                    RecordStoreNotFoundException ex = new RecordStoreNotFoundException();
                    ex.initCause(ioe);
                    throw ex;
                }
                this.writeToFile();
            }
        }
    }

    public int addRecord(byte[] data, int offset, int numBytes) throws RecordStoreNotOpenException, RecordStoreException, RecordStoreFullException {
        this.checkOpen();
        if (data == null) {
            this.records.addElement(null);
        } else {
            byte[] newData = new byte[numBytes];
            System.arraycopy(data, offset, newData, 0, numBytes);
            this.records.addElement(newData);
        }
        this.changeVersion();
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((RecordListener)this.listeners.elementAt(i)).recordAdded(this, this.records.size());
            }
        }
        this.writeToFile();
        return this.records.size();
    }

    public void closeRecordStore() throws RecordStoreNotOpenException, RecordStoreException {
        if (this.refCount > 0) {
            --this.refCount;
        }
    }

    public void deleteRecordStoreImpl() throws RecordStoreException {
        if (this.refCount > 0) {
            // empty if block
        }
        if (!this.isApplet() && this.file != null && !this.file.delete()) {
            throw new RecordStoreException("Cannot delete Store, File.delete() returned false for file: " + this.file);
        }
        this.records = null;
    }

    public void deleteRecord(int recordId) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        this.checkId(recordId);
        this.records.setElementAt(RECORD_INVALID, recordId - 1);
        this.writeToFile();
        this.changeVersion();
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((RecordListener)this.listeners.elementAt(i)).recordDeleted(this, recordId);
            }
        }
    }

    public long getLastModified() throws RecordStoreNotOpenException {
        this.checkOpen();
        return this.lastModified;
    }

    public String getName() throws RecordStoreNotOpenException {
        this.checkOpen();
        return this.recordStoreName;
    }

    public int getNextRecordID() throws RecordStoreNotOpenException, RecordStoreException {
        this.checkOpen();
        return this.records.size() + 1;
    }

    public int getNumRecords() throws RecordStoreNotOpenException {
        this.checkOpen();
        int result = 0;
        for (int i = 0; i < this.records.size(); ++i) {
            Object data = this.records.elementAt(i);
            if (data == RECORD_INVALID) continue;
            ++result;
        }
        return result;
    }

    public byte[] getRecord(int recordId) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        this.checkId(recordId);
        byte[] buffer = (byte[])this.records.elementAt(recordId - 1);
        if (buffer == RECORD_INVALID) {
            throw new InvalidRecordIDException("Record ID " + recordId + " is already deleted");
        }
        return buffer;
    }

    public int getRecord(int recordId, byte[] buffer, int offset) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException, ArrayIndexOutOfBoundsException {
        byte[] data = this.getRecord(recordId);
        if (data == RECORD_INVALID) {
            throw new InvalidRecordIDException("Record ID " + recordId + " is already deleted.");
        }
        System.arraycopy(data, 0, buffer, offset, data.length);
        return data.length;
    }

    public int getRecordSize(int recordId) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        return this.getRecord(recordId).length;
    }

    public int getSize() throws RecordStoreNotOpenException {
        this.checkOpen();
        int size = 0;
        size += 4;
        size += 8;
        for (int i = 0; i < this.records.size(); ++i) {
            Object obj = this.records.elementAt(i);
            size += 4;
            if (obj == null) continue;
            size += ((byte[])obj).length;
        }
        return size;
    }

    public int getSizeAvailable() throws RecordStoreNotOpenException {
        return Integer.MAX_VALUE;
    }

    public int getVersion() throws RecordStoreNotOpenException {
        this.checkOpen();
        return this.version;
    }

    public void setRecord(int recordId, byte[] data, int offset, int numBytes) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException, RecordStoreFullException {
        this.checkId(recordId);
        byte[] oldData = this.getRecord(recordId);
        if (oldData == RECORD_INVALID) {
            throw new InvalidRecordIDException("Record " + recordId + " is already deleted.");
        }
        if (data != null) {
            byte[] newData = new byte[numBytes];
            System.arraycopy(data, offset, newData, 0, numBytes);
            this.records.setElementAt(newData, recordId - 1);
        } else {
            this.records.setElementAt(null, recordId - 1);
        }
        this.writeToFile();
        this.changeVersion();
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((RecordListener)this.listeners.elementAt(i)).recordChanged(this, recordId);
            }
        }
    }

    public void setMode(int authmode, boolean writable) throws RecordStoreException {
        System.out.println("RecordStore.setMode() called with no effect!");
    }

    static {
        new Thread("RecordStoreImpl"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    RecordStoreImpl store;
                    Vector vector = todo;
                    synchronized (vector) {
                        while (todo.isEmpty()) {
                            try {
                                todo.wait();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        store = (RecordStoreImpl)todo.remove(0);
                    }
                    try {
                        store.doWriteToFile();
                        continue;
                    }
                    catch (Exception ioe) {
                        System.err.println("Error writing Records to file!");
                        ioe.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }
}

