/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.midlet;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.midlet.ApplicationManager;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.swing.JOptionPane;
import net.yura.grasshopper.SimpleBug;

public abstract class MIDlet {
    boolean inDestruction;
    private static final String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "seamonkey", "galeon", "kazehakase", "mozilla", "netscape"};

    protected MIDlet() {
        ApplicationManager.getInstance().activeClass = this.getClass();
    }

    protected abstract void destroyApp(boolean var1) throws MIDletStateChangeException;

    public String getAppProperty(String key) {
        String result = ApplicationManager.getInstance().jadFile.getValue(key);
        if (result == null) {
            result = ApplicationManager.getInstance().getProperty(key);
        }
        return result;
    }

    public void notifyDestroyed() {
        if (!this.inDestruction && ApplicationManager.isInitialized() && this == ApplicationManager.getInstance().active) {
            ApplicationManager.getInstance().destroy(false, false);
        }
    }

    public void notifyPaused() {
    }

    protected abstract void pauseApp();

    public void resumeRequest() {
    }

    protected abstract void startApp() throws MIDletStateChangeException;

    public static final void copyInputStream(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[1024];
        int len = 0;
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.flush();
        out.close();
    }

    public static final void unzip(String name) throws Exception {
        ZipEntry entry;
        ZipFile zipFile = new ZipFile(name);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            if (!entry.isDirectory()) continue;
            new File(entry.getName()).mkdir();
        }
        entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            InputStream in = zipFile.getInputStream(entry);
            FileOutputStream out = new FileOutputStream(entry.getName());
            MIDlet.copyInputStream(new BufferedInputStream(in), new BufferedOutputStream(out));
            in.close();
            out.flush();
            ((OutputStream)out).close();
        }
        zipFile.close();
    }

    public final boolean platformRequest(String url) throws ConnectionNotFoundException {
        if (url.startsWith("tel")) {
            System.out.println("ME4SE: MIDlet.platformRequest('" + url + "') called in order to initiate a phone call.");
        } else if (url.startsWith("grasshopper")) {
            try {
                String params = url.substring(url.indexOf(63) + 1);
                String[] s1 = params.split("\\&");
                String appName = "Unknown me4se app";
                String appVersion = "Unknown version";
                String locale = "";
                for (int c = 0; c < s1.length; ++c) {
                    String[] s2 = s1[c].split("\\=");
                    if ("name".equals(s2[0])) {
                        appName = s2[1];
                        continue;
                    }
                    if ("version".equals(s2[0])) {
                        appVersion = s2[1];
                        continue;
                    }
                    if ("locale".equals(s2[0])) {
                        locale = s2[1];
                        continue;
                    }
                    System.out.println("unknown grasshopper param: " + s1[c]);
                }
                try {
                    SimpleBug.initSimple((String)appName, (String)appVersion, (String)locale);
                    System.out.println("Grasshopper loaded");
                }
                catch (Throwable th) {
                    System.out.println("Grasshopper not loaded");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (url.startsWith("update:")) {
            String update = url.substring("update:".length());
            try {
                if (new File("no.update").exists()) {
                    System.out.println("UPDATE STOPPED BY no.update FILE");
                    return false;
                }
                String fileName = update.substring(update.lastIndexOf(47) + 1);
                InputStream in = new URL(update).openStream();
                FileOutputStream out = new FileOutputStream(new File(fileName));
                MIDlet.copyInputStream(new BufferedInputStream(in), new BufferedOutputStream(out));
                out.flush();
                out.close();
                in.close();
                if (fileName.toUpperCase().endsWith(".ZIP")) {
                    MIDlet.unzip(fileName);
                }
                JOptionPane.showMessageDialog(null, "update done! click OK to close.");
                System.exit(0);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (url.startsWith("clipboard://")) {
            if (url.startsWith("clipboard://get")) {
                String text = null;
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable contents = clipboard.getContents(null);
                if (contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        text = (String)contents.getTransferData(DataFlavor.stringFlavor);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (text == null) {
                    try {
                        System.clearProperty("clipboard.text");
                    }
                    catch (Throwable th) {
                        Properties sysProps = System.getProperties();
                        sysProps.remove("clipboard.text");
                    }
                } else {
                    System.setProperty("clipboard.text", text);
                }
            } else if (url.startsWith("clipboard://put/")) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                String text = url.substring("clipboard://put/".length());
                if (!"".equals(text)) {
                    clipboard.setContents(new StringSelection(text), new ClipboardOwner(){

                        public void lostOwnership(Clipboard clipboard, Transferable contents) {
                        }
                    });
                }
            }
        } else {
            if (ApplicationManager.getInstance().applet != null) {
                try {
                    ApplicationManager.getInstance().applet.getAppletContext().showDocument(new URL(url));
                }
                catch (Exception e) {
                    ConnectionNotFoundException ex = new ConnectionNotFoundException(e.toString());
                    ex.initCause(e);
                    throw ex;
                }
            }
            try {
                this.openURL(url);
            }
            catch (Exception e) {
                ConnectionNotFoundException ex = new ConnectionNotFoundException(e.toString());
                ex.initCause(e);
                throw ex;
            }
        }
        return false;
    }

    public final int checkPermission(String permission) {
        System.out.println("MIDlet.checkPermission() called with no effect!");
        return -4711;
    }

    private void openURL(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                boolean found = false;
                for (int c = 0; c < browsers.length; ++c) {
                    String browser = browsers[c];
                    if (found) continue;
                    boolean bl = found = Runtime.getRuntime().exec(new String[]{"which", browser}).waitFor() == 0;
                    if (!found) continue;
                    Runtime.getRuntime().exec(new String[]{browser, url});
                }
                if (!found) {
                    throw new Exception(Arrays.toString(browsers));
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error attempting to launch web browser\n" + e.toString());
        }
    }
}

