/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import android.graphics.ColorMatrix;
import java.awt.Component;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.ApplicationManager;

public class Image {
    private static final int TRANS_NONE = 0;
    private static final int TRANS_MIRROR_ROT180 = 1;
    private static final int TRANS_MIRROR = 2;
    private static final int TRANS_ROT180 = 3;
    private static final int TRANS_MIRROR_ROT270 = 4;
    private static final int TRANS_ROT90 = 5;
    private static final int TRANS_ROT270 = 6;
    private static final int TRANS_MIRROR_ROT90 = 7;
    public boolean _transparent;
    public BufferedImage _image;
    boolean mutable;
    static Component helper = new Panel();
    String name;
    static int imageCreationCount;

    protected Image(BufferedImage image, boolean mutable, boolean toGray, String name) {
        this._image = image;
        this.mutable = mutable;
        this.name = name;
    }

    public static Image createImage(int w, int h) {
        BufferedImage img = new BufferedImage(w, h, 2);
        java.awt.Graphics g = img.getGraphics();
        g.setColor(ApplicationManager.getInstance().bgColor);
        g.fillRect(0, 0, w, h);
        return new Image(img, true, false, "createImage(x,y)");
    }

    public static Image createImage(byte[] data, int start, int len) {
        try {
            return new Image(ApplicationManager.getInstance().createImage(data, start, len), false, true, "createImage(byte[] data, start, len)");
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Image createImage(String name) throws IOException {
        return new Image(ApplicationManager.getInstance().getImage(name), false, true, name);
    }

    public static Image createImage(Image source) {
        if (source == null) {
            throw new NullPointerException();
        }
        if (!source.isMutable()) {
            return source;
        }
        Image copy = Image.createImage(source.getWidth(), source.getHeight());
        copy.getGraphics().drawImage(source, 0, 0, 20);
        copy.mutable = false;
        return copy;
    }

    public Graphics getGraphics() {
        if (!this.mutable) {
            throw new IllegalStateException();
        }
        return new Graphics(null, this._image, null);
    }

    public int getWidth() {
        return this._image.getWidth();
    }

    public int getHeight() {
        return this._image.getHeight();
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public static Image createImage(Image image, int x, int y, int width, int height, int transform) {
        int tw;
        int th;
        int[] buf = new int[width * height];
        image.getRGB(buf, 0, width, x, y, width, height);
        if ((transform & 4) != 0) {
            th = width;
            tw = height;
        } else {
            th = height;
            tw = width;
        }
        if (transform != 0) {
            int[] trans = new int[buf.length];
            int sp = 0;
            for (int sy = 0; sy < height; ++sy) {
                int td;
                int ty;
                int tx;
                switch (transform) {
                    case 5: {
                        tx = tw - sy - 1;
                        ty = 0;
                        td = tw;
                        break;
                    }
                    case 3: {
                        tx = tw - 1;
                        ty = th - sy - 1;
                        td = -1;
                        break;
                    }
                    case 6: {
                        tx = sy;
                        ty = th - 1;
                        td = -tw;
                        break;
                    }
                    case 2: {
                        tx = tw - 1;
                        ty = sy;
                        td = -1;
                        break;
                    }
                    case 7: {
                        tx = tw - sy - 1;
                        ty = th - 1;
                        td = -tw;
                        break;
                    }
                    case 1: {
                        tx = 0;
                        ty = th - sy - 1;
                        td = 1;
                        break;
                    }
                    case 4: {
                        tx = sy;
                        ty = 0;
                        td = tw;
                        break;
                    }
                    default: {
                        throw new RuntimeException("illegal transformation: " + transform);
                    }
                }
                int tp = ty * tw + tx;
                for (int sx = 0; sx < width; ++sx) {
                    trans[tp] = buf[sp++];
                    tp += td;
                }
            }
            buf = trans;
        }
        return Image.createRGBImage(buf, tw, th, true);
    }

    public static Image createImage(InputStream stream) throws IOException {
        Image img = new Image(ApplicationManager.getInstance().createImage(stream), false, true, "createImage(InputStream)");
        return img;
    }

    public static Image createRGBImage(int[] rgb, int width, int height, boolean processAlpha) {
        if (!processAlpha) {
            int[] opaque = new int[rgb.length];
            for (int i = 0; i < rgb.length; ++i) {
                opaque[i] = rgb[i] | 0xFF000000;
            }
            rgb = opaque;
        }
        BufferedImage bi = new BufferedImage(width, height, 2);
        bi.setRGB(0, 0, width, height, rgb, 0, width);
        return new Image(bi, false, true, "createRGBImage");
    }

    public void getRGB(int[] rgbData, int offset, int scanlength, int x, int y, int width, int height) {
        PixelGrabber pg = new PixelGrabber(this._image, x, y, width, height, rgbData, offset, scanlength);
        boolean ok = false;
        do {
            try {
                pg.grabPixels(0L);
                ok = true;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (!ok);
    }

    public void setRGB(int x, int y, int rgb) {
        this._image.setRGB(x, y, rgb);
    }

    public static void filter(Image source, Image img, ColorMatrix cm) {
        FilteredImageSource filteredSrc = new FilteredImageSource(source._image.getSource(), cm);
        java.awt.Image image = Toolkit.getDefaultToolkit().createImage(filteredSrc);
        java.awt.Graphics g = img._image.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
    }
}

