/*
 * Decompiled with CFR 0.152.
 */
package net.yura.grasshopper;

import java.io.Writer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.yura.grasshopper.BugManager;
import net.yura.grasshopper.ReallySimpleFormatter;

public class TextHandler
extends Handler {
    private boolean doneHeader;
    private Writer writer;
    private Level pushLevel;
    private BugManager sps;

    public TextHandler(Writer writer, Level pushLevel, BugManager sps) {
        this.writer = writer;
        this.pushLevel = pushLevel;
        this.sps = sps;
        this.setFormatter(new ReallySimpleFormatter());
    }

    public void publish(LogRecord record) {
        String msg;
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            msg = this.getFormatter().format(record);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
            return;
        }
        try {
            if (!this.doneHeader) {
                this.writer.write(this.getFormatter().getHead(this));
                this.doneHeader = true;
            }
            this.writer.write(msg);
            this.writer.flush();
        }
        catch (Exception ex) {
            this.reportError(null, ex, 1);
        }
        if (record.getLevel().intValue() >= this.pushLevel.intValue()) {
            BugManager.action(this.sps, record.getLevel() + " " + record.getMillis() + " " + record.getMessage() + " " + record.getThrown());
        }
    }

    public void flush() {
    }

    public void close() throws SecurityException {
        try {
            if (!this.doneHeader) {
                this.writer.write(this.getFormatter().getHead(this));
                this.doneHeader = true;
            }
            this.writer.write(this.getFormatter().getTail(this));
            this.writer.flush();
            this.writer.close();
        }
        catch (Exception ex) {
            this.reportError(null, ex, 3);
        }
        this.writer = null;
    }
}

