/*
 * Decompiled with CFR 0.152.
 */
package net.yura.grasshopper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.mime.content.AbstractContentBody;

public class LogFileBody
extends AbstractContentBody {
    File file;
    long length = -1L;

    public LogFileBody(File file) {
        super("text/plain");
        this.file = file;
    }

    public String getFilename() {
        return null;
    }

    public String getCharset() {
        return "US-ASCII";
    }

    public String getTransferEncoding() {
        return "8bit";
    }

    public long getContentLength() {
        if (this.length == -1L) {
            this.length = this.file.length();
        }
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        FileInputStream in = new FileInputStream(this.file);
        try {
            int l;
            long totalLength = this.getContentLength();
            long totalWritten = 0L;
            byte[] tmp = new byte[2048];
            while ((l = ((InputStream)in).read(tmp)) != -1) {
                if (totalWritten + (long)l > totalLength) {
                    out.write(tmp, 0, (int)(totalLength - totalWritten));
                    break;
                }
                totalWritten += (long)l;
                out.write(tmp, 0, l);
            }
            out.flush();
        }
        finally {
            ((InputStream)in).close();
        }
    }
}

