/*
 * Decompiled with CFR 0.152.
 */
package net.yura.grasshopper;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.yura.grasshopper.ReallySimpleFormatter;

public class ConsoleHandler
extends Handler {
    PrintStream out = new PrintStream(new FileOutputStream(FileDescriptor.out));
    PrintStream err = new PrintStream(new FileOutputStream(FileDescriptor.err));

    public ConsoleHandler() {
        this.setFormatter(new ReallySimpleFormatter());
    }

    public synchronized void publish(LogRecord record) {
        String msg;
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            msg = this.getFormatter().format(record);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
            return;
        }
        try {
            PrintStream ps = record.getLevel().intValue() >= Level.WARNING.intValue() ? this.err : this.out;
            ps.print(msg);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 1);
        }
    }

    public synchronized void flush() {
    }

    public synchronized void close() throws SecurityException {
        try {
            this.out.close();
            this.err.close();
        }
        catch (Exception ex) {
            this.reportError(null, ex, 3);
        }
        this.out = null;
        this.err = null;
    }
}

