/*
 * Decompiled with CFR 0.152.
 */
package net.yura.grasshopper;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import net.yura.grasshopper.BugUIInfo;
import net.yura.grasshopper.LogFileBody;
import org.apache.http.Header;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.StringBody;

public class BugSubmitterMultipart {
    static void send(String url, Map map) throws IOException {
        MultipartEntity requestContent = new MultipartEntity();
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            String key = String.valueOf(next.getKey());
            Object value = next.getValue();
            if (value instanceof File) {
                requestContent.addPart(key, new LogFileBody((File)value));
                continue;
            }
            requestContent.addPart(key, new StringBody(String.valueOf(value)));
        }
        byte[][] images = BugUIInfo.getFrames();
        for (int c = 0; c < images.length; ++c) {
            requestContent.addPart("img" + c, new ByteArrayBody(images[c], "frame_" + c + ".png"));
        }
        BugSubmitterMultipart.doPost(url, requestContent);
    }

    public static void doPost(String url, MultipartEntity requestContent) throws IOException {
        String line;
        URLConnection conn = new URL(url).openConnection();
        conn.setDoOutput(true);
        Header contentType = requestContent.getContentType();
        conn.setRequestProperty(contentType.getName(), contentType.getValue());
        conn.setRequestProperty("Content-Length", String.valueOf(requestContent.getContentLength()));
        OutputStream out = conn.getOutputStream();
        requestContent.writeTo(out);
        out.close();
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = rd.readLine()) != null) {
        }
        rd.close();
    }
}

