/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.flashgui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.guishared.AboutDialog;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.ui.flashgui.FlashRiskAdapter;
import net.yura.domination.ui.flashgui.JoinDialog;

public class MainMenu
extends JPanel
implements MouseInputListener,
KeyListener {
    private static final String version = "2";
    private static final String product = "Flash GUI for " + RiskUtil.GAME_NAME;
    private BufferedImage MenuImage;
    private BufferedImage Server;
    private Risk myrisk;
    private FlashRiskAdapter fra;
    private boolean serverRunning;
    private JoinDialog joinDialog;
    private static final int BUTTON_EXIT = 100;
    private static final int BUTTON_NEW = 1;
    private static final int BUTTON_SERVER = 2;
    private static final int BUTTON_LOADGAME = 3;
    private static final int BUTTON_HELP = 4;
    private static final int BUTTON_JOIN = 5;
    private static final int BUTTON_ABOUT = 6;
    private static final int BUTTON_LOBBY = 7;
    private static final int BUTTON_DONATE = 8;
    private JLabel lobby;
    private ResourceBundle resBundle = TranslationBundle.getBundle();
    private boolean showLobby;
    private Cursor hand;
    private Cursor defaultCursor;
    private int button;
    private int currentButton;
    private int pressedButton;
    private int highlightButton;

    public MainMenu(Risk r, Frame gui) {
        this.myrisk = r;
        this.fra = new FlashRiskAdapter(this, this.myrisk);
        this.MenuImage = RiskUIUtil.getUIImage(this.getClass(), "menu.jpg");
        this.Server = this.MenuImage.getSubimage(400, 490, 60, 60);
        Dimension menuSize = new Dimension(400, 550);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setPreferredSize(menuSize);
        this.setMinimumSize(menuSize);
        this.setMaximumSize(menuSize);
        this.highlightButton = 0;
        this.serverRunning = false;
        gui.setFocusTraversalKeysEnabled(false);
        gui.addKeyListener(this);
        this.setLayout(null);
        this.lobby = new JLabel(this.resBundle.getString("mainmenu.online"), new ImageIcon(this.getClass().getResource("earth.gif")), 0);
        this.lobby.setBounds(152, 409, 95, 95);
        this.lobby.setHorizontalTextPosition(0);
        this.lobby.setFont(new Font("Arial", 1, 18));
        this.lobby.setVisible(false);
        this.lobby.setForeground(Color.BLACK);
        this.add(this.lobby);
        this.hand = Cursor.getPredefinedCursor(12);
        this.defaultCursor = this.getCursor();
    }

    public void setServerRunning(boolean s) {
        this.serverRunning = s;
        this.repaint();
    }

    public void hideJoinDialog(boolean a) {
        if (!a) {
            this.joinDialog.exitForm();
            this.joinDialog = null;
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void paintComponent(Graphics g) {
        g.drawImage(this.MenuImage, 0, 0, 400, 550, 0, 0, 400, 550, this);
        if (this.highlightButton == 1) {
            g.drawImage(this.MenuImage, 57, 219, 187, 269, 400, 0, 530, 50, this);
        } else if (this.highlightButton == 2) {
            g.drawImage(this.MenuImage, 212, 219, 342, 269, 400, 50, 530, 100, this);
        } else if (this.highlightButton == 3) {
            g.drawImage(this.MenuImage, 57, 279, 187, 329, 400, 100, 530, 150, this);
        } else if (this.highlightButton == 4) {
            g.drawImage(this.MenuImage, 212, 279, 342, 329, 400, 150, 530, 200, this);
        } else if (this.highlightButton == 5) {
            g.drawImage(this.MenuImage, 57, 339, 187, 389, 400, 200, 530, 250, this);
        } else if (this.highlightButton == 6) {
            g.drawImage(this.MenuImage, 212, 339, 342, 389, 400, 250, 530, 300, this);
        } else if (this.button == 1) {
            g.drawImage(this.MenuImage, 57, 219, 187, 269, 530, 0, 660, 50, this);
        } else if (this.button == 2) {
            g.drawImage(this.MenuImage, 212, 219, 342, 269, 530, 50, 660, 100, this);
        } else if (this.button == 3) {
            g.drawImage(this.MenuImage, 57, 279, 187, 329, 530, 100, 660, 150, this);
        } else if (this.button == 4) {
            g.drawImage(this.MenuImage, 212, 279, 342, 329, 530, 150, 660, 200, this);
        } else if (this.button == 5) {
            g.drawImage(this.MenuImage, 57, 339, 187, 389, 530, 200, 660, 250, this);
        } else if (this.button == 6) {
            g.drawImage(this.MenuImage, 212, 339, 342, 389, 530, 250, 660, 300, this);
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontRenderContext frc = g2.getFontRenderContext();
        Font font = g2.getFont();
        g2.setColor(Color.black);
        TextLayout tl = new TextLayout(this.resBundle.getString("mainmenu.newgame"), font, frc);
        tl.draw(g2, (float)(122.0 - tl.getBounds().getWidth() / 2.0), 247.0f);
        if (this.serverRunning) {
            tl = new TextLayout(this.resBundle.getString("mainmenu.stopserver"), font, frc);
            tl.draw(g2, (float)(277.0 - tl.getBounds().getWidth() / 2.0), 247.0f);
            g.drawImage(this.Server, 340, 490, this);
        } else {
            tl = new TextLayout(this.resBundle.getString("mainmenu.startserver"), font, frc);
            tl.draw(g2, (float)(277.0 - tl.getBounds().getWidth() / 2.0), 247.0f);
        }
        tl = new TextLayout(this.resBundle.getString("mainmenu.loadgame"), font, frc);
        tl.draw(g2, (float)(122.0 - tl.getBounds().getWidth() / 2.0), 309.0f);
        tl = new TextLayout(this.resBundle.getString("mainmenu.help"), font, frc);
        tl.draw(g2, (float)(277.0 - tl.getBounds().getWidth() / 2.0), 309.0f);
        tl = new TextLayout(this.resBundle.getString("mainmenu.joingame"), font, frc);
        tl.draw(g2, (float)(122.0 - tl.getBounds().getWidth() / 2.0), 369.0f);
        tl = new TextLayout(this.resBundle.getString("mainmenu.about"), font, frc);
        tl.draw(g2, (float)(277.0 - tl.getBounds().getWidth() / 2.0), 369.0f);
        font = new Font("Arial", 1, 24);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.highlightButton = 0;
        this.currentButton = this.insideButton(e.getX(), e.getY());
        if (this.currentButton != 0) {
            this.pressedButton = this.currentButton;
            this.button = this.currentButton;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        int thebutton = 0;
        if (this.pressedButton == this.currentButton) {
            thebutton = this.pressedButton;
        }
        if (this.button != 0) {
            this.button = 0;
        }
        this.highlightButton = this.currentButton;
        this.repaint();
        this.activateButton(thebutton);
    }

    private void activateButton(int thebutton) {
        if (thebutton != 0) {
            switch (thebutton) {
                case 1: {
                    this.myrisk.parser("newgame");
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.removeMouseListener(this);
                    this.removeMouseMotionListener(this);
                    break;
                }
                case 2: {
                    if (this.serverRunning) {
                        this.myrisk.parser("killserver");
                        break;
                    }
                    this.myrisk.parser("startserver");
                    break;
                }
                case 3: {
                    String name = RiskUIUtil.getLoadFileName(RiskUIUtil.findParentFrame(this));
                    if (name == null) break;
                    this.myrisk.parser("loadgame " + name);
                    break;
                }
                case 4: {
                    try {
                        RiskUtil.openDocs(TranslationBundle.getBundle().getString("helpfiles.flash"));
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(RiskUIUtil.findParentFrame(this), "Unable to open manual: " + e.getMessage(), "Error", 0);
                    }
                    break;
                }
                case 5: {
                    Frame frame = RiskUIUtil.findParentFrame(this);
                    this.joinDialog = new JoinDialog(frame, true, this.myrisk);
                    Dimension frameSize = frame.getSize();
                    Dimension aboutSize = this.joinDialog.getPreferredSize();
                    int x = frame.getLocation().x + (frameSize.width - aboutSize.width) / 2;
                    int y = frame.getLocation().y + (frameSize.height - aboutSize.height) / 2;
                    if (x < 0) {
                        x = 0;
                    }
                    if (y < 0) {
                        y = 0;
                    }
                    this.joinDialog.setLocation(x, y + 10);
                    this.joinDialog.setVisible(true);
                    break;
                }
                case 7: {
                    if (!this.showLobby) break;
                    RiskUIUtil.runLobby(this.myrisk);
                    break;
                }
                case 6: {
                    Frame frame = RiskUIUtil.findParentFrame(this);
                    RiskUIUtil.openAbout(frame, product, version);
                    break;
                }
                case 100: {
                    this.exit();
                    break;
                }
                case 8: {
                    RiskUIUtil.donate(this);
                }
            }
            this.currentButton = 0;
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        int oldhighlightButton = this.highlightButton;
        int newhighlightButton = this.insideButton(e.getX(), e.getY());
        if (oldhighlightButton != newhighlightButton) {
            this.highlightButton = newhighlightButton;
            this.repaint();
        }
        if (newhighlightButton == 8) {
            if (this.getCursor() == this.defaultCursor) {
                this.setCursor(this.hand);
            }
        } else if (this.getCursor() == this.hand) {
            this.setCursor(this.defaultCursor);
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.currentButton = this.insideButton(e.getX(), e.getY());
        if (this.pressedButton == this.currentButton) {
            if (this.button != this.pressedButton) {
                this.button = this.pressedButton;
                this.repaint();
            }
        } else if (this.button != 0) {
            this.button = 0;
            this.repaint();
        }
    }

    public int insideButton(int x, int y) {
        int W = 116;
        int H = 31;
        int B = 0;
        int yrel = Math.abs(455 - y);
        int xrel = (int)(Math.sqrt(2255 - yrel * yrel) * 95.0 / 95.0);
        if (x >= 65 && x < 65 + W && y >= 228 && y < 228 + H) {
            B = 1;
        } else if (x >= 220 && x < 220 + W && y >= 228 && y < 228 + H) {
            B = 2;
        } else if (x >= 65 && x < 65 + W && y >= 289 && y < 289 + H) {
            B = 3;
        } else if (x >= 220 && x < 220 + W && y >= 289 && y < 289 + H) {
            B = 4;
        } else if (x >= 65 && x < 65 + W && y >= 350 && y < 350 + H) {
            B = 5;
        } else if (x >= 220 && x < 220 + W && y >= 350 && y < 350 + H) {
            B = 6;
        } else if (x >= 200 - xrel && x < 200 + xrel) {
            B = 7;
        } else if (x >= 0 && x < 115 && y >= this.getHeight() - 50 && y < this.getHeight()) {
            B = 8;
        }
        return B;
    }

    public void keyReleased(KeyEvent event) {
        switch (event.getKeyCode()) {
            case 9: {
                this.highlightButton = event.isShiftDown() ? --this.highlightButton : ++this.highlightButton;
                if (this.highlightButton > 7) {
                    this.highlightButton = 1;
                } else if (this.highlightButton < 1) {
                    this.highlightButton = 7;
                }
                this.repaint();
                break;
            }
            case 10: 
            case 32: {
                this.activateButton(this.highlightButton);
                break;
            }
            case 78: {
                this.activateButton(1);
                break;
            }
            case 76: {
                this.activateButton(3);
                break;
            }
            case 27: 
            case 81: {
                this.activateButton(100);
                break;
            }
            case 74: {
                this.activateButton(5);
                break;
            }
            case 65: {
                this.activateButton(6);
                break;
            }
            case 83: {
                this.activateButton(2);
                break;
            }
            case 72: {
                this.activateButton(4);
                break;
            }
            case 79: {
                this.activateButton(7);
            }
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }

    private void exit() {
        this.myrisk.deleteRiskListener(this.fra);
    }

    public void addLobbyButton() {
        if (RiskUIUtil.getAddLobby(this.myrisk)) {
            this.lobby.setVisible(true);
            this.showLobby = true;
            this.repaint();
        }
    }

    public static void main(String[] argv) {
        RiskUIUtil.parseArgs(argv);
        MainMenu mm = MainMenu.newMainMenuFrame(new Risk(), 3);
        mm.addLobbyButton();
    }

    public static MainMenu newMainMenuFrame(Risk r, int a) {
        JFrame gui = new JFrame();
        final MainMenu mm = new MainMenu(r, gui);
        gui.setContentPane(mm);
        gui.setIconImage(Toolkit.getDefaultToolkit().getImage(AboutDialog.class.getResource("icon.gif")));
        gui.setTitle(TranslationBundle.getBundle().getString("mainmenu.title"));
        gui.setResizable(false);
        gui.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = gui.getSize();
        frameSize.height = frameSize.height > screenSize.height ? screenSize.height : frameSize.height;
        frameSize.width = frameSize.width > screenSize.width ? screenSize.width : frameSize.width;
        gui.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        gui.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                mm.exit();
            }
        });
        gui.setDefaultCloseOperation(a);
        gui.setVisible(true);
        return mm;
    }
}

