/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.lobby.mini;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.microedition.lcdui.Image;
import net.yura.domination.ImageManager;
import net.yura.domination.engine.OnlineRisk;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.lobby.mini.GameRenderer;
import net.yura.domination.mapstore.MapChooser;
import net.yura.lobby.client.Connection;
import net.yura.lobby.client.LobbyClient;
import net.yura.lobby.client.LobbyCom;
import net.yura.lobby.model.Game;
import net.yura.lobby.model.GameType;
import net.yura.lobby.model.Player;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.Midlet;
import net.yura.mobile.gui.cellrenderer.ListCellRenderer;
import net.yura.mobile.gui.components.OptionPane;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.layout.XULLoader;
import net.yura.swingme.core.CoreUtil;

public class MiniLobbyClient
implements LobbyClient,
ActionListener {
    static final Logger logger = Logger.getLogger(MiniLobbyClient.class.getName());
    public net.yura.mobile.util.Properties resBundle = CoreUtil.wrap(TranslationBundle.getBundle());
    XULLoader loader;
    net.yura.mobile.gui.components.List list;
    Connection mycom;
    String gameName = "Domination";
    Risk myrisk;
    String myusername;
    GameType theGame;

    public MiniLobbyClient(Risk risk) {
        this.myrisk = risk;
        try {
            this.loader = XULLoader.load((InputStream)Midlet.getResourceAsStream((String)"/ms_lobby.xml"), (ActionListener)this, (net.yura.mobile.util.Properties)this.resBundle);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.list = (net.yura.mobile.gui.components.List)this.loader.find("ResultList");
        this.list.setCellRenderer((ListCellRenderer)new GameRenderer(this));
        String uuid = MiniLobbyClient.getMyUUID();
        this.mycom = new LobbyCom(uuid);
        this.mycom.addEventListener((LobbyClient)this);
        this.mycom.connect("heather", 1964);
    }

    public static String getMyUUID() {
        Properties prop = new Properties();
        File lobbySettingsFile = new File(System.getProperty("user.home"), ".lobby");
        try {
            prop.load(new FileInputStream(lobbySettingsFile));
        }
        catch (Exception ex) {
            // empty catch block
        }
        String uuid = prop.getProperty("uuid");
        if (uuid != null) {
            return uuid;
        }
        uuid = UUID.randomUUID().toString();
        prop.setProperty("uuid", uuid);
        try {
            prop.store(new FileOutputStream(lobbySettingsFile), "yura.net Lobby");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uuid;
    }

    public Panel getRoot() {
        return (Panel)this.loader.getRoot();
    }

    public void actionPerformed(String actionCommand) {
        if ("listSelect".equals(actionCommand)) {
            net.yura.mobile.gui.components.List list = (net.yura.mobile.gui.components.List)this.loader.find("ResultList");
            Game game = (Game)list.getSelectedValue();
            if (game != null) {
                int state = game.getState(this.whoAmI());
                switch (state) {
                    case 1: {
                        this.mycom.joinGame(game.getGameId());
                        break;
                    }
                    case 2: {
                        this.mycom.leaveGame(game.getGameId());
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.mycom.playGame(game);
                    }
                }
            }
        } else if (!"create".equals(actionCommand)) {
            if ("close".equals(actionCommand)) {
                this.mycom.disconnect();
                this.getRoot().getWindow().setVisible(false);
            } else {
                OptionPane.showMessageDialog(null, (Object)("unknown command: " + actionCommand), null, (int)1);
            }
        }
    }

    public Icon getIconForGame(Game game) {
        ImageManager.LazyIcon aicon = ImageManager.get(game);
        if (aicon == null) {
            aicon = ImageManager.newIcon(game, 50, 50);
            this.loadImg(game);
        }
        return aicon;
    }

    void loadImg(Game game) {
        String mapName = MiniLobbyClient.getMapName(game.getOptions());
        Hashtable info = RiskUtil.loadInfo(mapName, false);
        String prv = (String)info.get("prv");
        InputStream in = null;
        if (prv != null) {
            in = MapChooser.getLocalePreviewImg("preview/" + prv);
        }
        if (in == null) {
            in = MapChooser.getLocalePreviewImg((String)info.get("pic"));
        }
        Image img = null;
        if (in != null) {
            try {
                img = MapChooser.createImage(in);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "odd!", ex);
            }
        }
        if (img != null) {
            ImageManager.gotImg(game, img);
            this.list.repaint();
        }
    }

    static String getMapName(String options) {
        String[] lines = options.split(RiskUtil.quote("\n"));
        String choosemap = lines[3];
        return choosemap.substring("choosemap ".length());
    }

    public ClassLoader getClassLoader(GameType gameType) {
        return this.getClass().getClassLoader();
    }

    public void connected() {
        this.mycom.getGameTypes();
    }

    public void disconnected() {
    }

    public void connecting(String message) {
        logger.info(message);
    }

    public void error(String error) {
        logger.info(error);
    }

    public void setUsername(String name, boolean guest) {
        this.myusername = name;
    }

    public String whoAmI() {
        return this.myusername;
    }

    public void addGameType(List gametypes) {
        for (int c = 0; c < gametypes.size(); ++c) {
            GameType gametype = (GameType)gametypes.get(c);
            if (this.gameName.equals(gametype.getName())) {
                this.theGame = gametype;
                this.mycom.getGames(gametype);
                continue;
            }
            logger.info("ignore GameType: " + gametype);
        }
    }

    public void addOrUpdateGame(Game game) {
        int index = this.list.indexOf((Object)game);
        if (index >= 0) {
            this.list.setElementAt((Object)game, index);
        } else {
            this.list.addElement((Object)game);
        }
        this.list.repaint();
    }

    public void removeGame(String gameid) {
        for (int c = 0; c < this.list.getSize(); ++c) {
            Game game = (Game)this.list.getElementAt(c);
            if (!gameid.equals(game.getGameId())) continue;
            this.list.removeElementAt(c);
            break;
        }
        this.list.repaint();
    }

    public void messageForGame(String gameid, Object message) {
        if (message instanceof String) {
            this.stringForGame(gameid, (String)message);
        } else if (message instanceof byte[]) {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream((byte[])message);
                ObjectInputStream oin = new ObjectInputStream(in);
                Object object = oin.readObject();
                this.objectForGame(gameid, object);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            throw new RuntimeException("unknown object");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void stringForGame(String gameId, String message) {
        if (message.startsWith("LOBBY_NEEDINPUT ")) {
            String who = message.substring(16, message.length());
            if (!this.whoAmI().equals(who)) return;
        }
        if (message.equals("LOBBY_GAMEOVER")) return;
        this.myrisk.parserFromNetwork(message);
    }

    private void objectForGame(final String gameId, Object object) {
        Map map = (Map)object;
        String command = (String)map.get("command");
        if ("game".equals(command)) {
            String address = (String)map.get("playerId");
            RiskGame game = (RiskGame)map.get("game");
            OnlineRisk lrisk = new OnlineRisk(){

                public void sendUserCommand(String messagefromgui) {
                    MiniLobbyClient.this.mycom.sendGameMessage(gameId, (Object)messagefromgui);
                }

                public void sendGameCommand(String mtemp) {
                    logger.info("ignore GameCommand " + mtemp);
                }

                public void close() {
                    MiniLobbyClient.this.mycom.closeGame(gameId);
                }
            };
            this.myrisk.createGame(address, game, lrisk);
        } else if ("rename".equals(command)) {
            String myName = this.whoAmI();
            String oldName = (String)map.get("oldName");
            String newName = (String)map.get("newName");
            this.myrisk.renamePlayer(oldName, newName);
            if (myName.equals(newName)) {
                this.myrisk.joinAs(newName);
            }
        } else {
            throw new RuntimeException("unknown command " + command);
        }
    }

    public void serverMessage(String message) {
    }

    public void privateMessage(String fromwho, String message) {
    }

    public void incomingChat(String roomid, String fromwho, String message) {
    }

    public void addPlayer(String roomid, Player player) {
    }

    public void removePlayer(String roomid, String player) {
    }

    public void renamePlayer(String oldname, String newname, int newtype) {
    }

    public void addMainRoom(String roomid) {
    }

    public void setUserInfo(String user, List info) {
    }

    public void newMainRoomJoined(String id) {
    }
}

