/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.core;

import java.io.Serializable;
import java.util.Vector;
import net.yura.domination.engine.core.Card;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.Mission;
import net.yura.domination.engine.core.Statistic;

public class Player
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int PLAYER_HUMAN = 0;
    public static final int PLAYER_AI_CRAP = 3;
    public static final int PLAYER_AI_EASY = 1;
    public static final int PLAYER_AI_HARD = 2;
    private String name;
    private int color;
    private int extraArmies;
    private Vector cardsOwned;
    private Vector territoriesOwned;
    private Vector playersEliminated;
    private Country capital;
    private Mission mission;
    private int type;
    private String address;
    private Vector Statistics;
    protected Statistic currentStatistic;
    private boolean autoendgo;
    private boolean autodefend;
    public static final int noaFORcard = 2;

    public Player(int t, String n, int c, String a) {
        this.type = t;
        this.name = n;
        this.color = c;
        this.territoriesOwned = new Vector();
        this.cardsOwned = new Vector();
        this.playersEliminated = new Vector();
        this.extraArmies = 0;
        this.address = a;
        this.autoendgo = true;
        this.autodefend = true;
        this.Statistics = new Vector();
        this.currentStatistic = new Statistic();
        this.Statistics.add(this.currentStatistic);
    }

    public void rename(String na) {
        this.name = na;
    }

    public String toString() {
        return this.name;
    }

    public void nextTurn() {
        this.currentStatistic = new Statistic();
        this.Statistics.add(this.currentStatistic);
    }

    public int[] getStatistics(int a) {
        int[] thing = new int[this.Statistics.size()];
        for (int c = 0; c < thing.length; ++c) {
            thing[c] = ((Statistic)this.Statistics.elementAt(c)).get(a);
        }
        return thing;
    }

    public int getNoArmies() {
        int n = 0;
        for (int c = 0; c < this.territoriesOwned.size(); ++c) {
            n += ((Country)this.territoriesOwned.elementAt(c)).getArmies();
        }
        return n;
    }

    public String getAddress() {
        return this.address;
    }

    public String getName() {
        return this.name;
    }

    public int getColor() {
        return this.color;
    }

    public int getExtraArmies() {
        return this.extraArmies;
    }

    public void addArmies(int n) {
        this.extraArmies += n;
    }

    public void loseExtraArmy(int n) {
        this.extraArmies -= n;
    }

    public void giveCard(Card card) {
        this.cardsOwned.add(card);
    }

    public Vector getCards() {
        return this.cardsOwned;
    }

    public Country getCapital() {
        return this.capital;
    }

    public void setCapital(Country c) {
        this.capital = c;
    }

    public Mission getMission() {
        return this.mission;
    }

    public void setMission(Mission m) {
        this.mission = m;
    }

    public Card takeCard() {
        Card c = (Card)this.cardsOwned.firstElement();
        this.cardsOwned.removeElementAt(0);
        return c;
    }

    public void tradeInCards(Card card1, Card card2, Card card3) {
        if (this.territoriesOwned.contains(card1.getCountry())) {
            card1.getCountry().addArmies(2);
            this.currentStatistic.addReinforcements(2);
        } else if (this.territoriesOwned.contains(card2.getCountry())) {
            card2.getCountry().addArmies(2);
            this.currentStatistic.addReinforcements(2);
        } else if (this.territoriesOwned.contains(card3.getCountry())) {
            card3.getCountry().addArmies(2);
            this.currentStatistic.addReinforcements(2);
        }
        this.cardsOwned.remove(card1);
        this.cardsOwned.remove(card2);
        this.cardsOwned.remove(card3);
        this.cardsOwned.trimToSize();
    }

    public Vector getTerritoriesOwned() {
        return this.territoriesOwned;
    }

    public int getNoTerritoriesOwned() {
        return this.territoriesOwned.size();
    }

    public void newCountry(Country newCountry) {
        this.territoriesOwned.addElement(newCountry);
    }

    public void lostCountry(Country lessCountry) {
        this.territoriesOwned.remove(lessCountry);
        this.territoriesOwned.trimToSize();
    }

    public void addPlayersEliminated(Player p) {
        this.playersEliminated.add(p);
    }

    public Vector getPlayersEliminated() {
        return this.playersEliminated;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int t) {
        this.type = t;
    }

    public void setAddress(String a) {
        this.address = a;
    }

    public void setAutoEndGo(boolean b) {
        this.autoendgo = b;
    }

    public boolean getAutoEndGo() {
        return this.autoendgo;
    }

    public void setAutoDefend(boolean b) {
        this.autodefend = b;
    }

    public boolean getAutoDefend() {
        return this.autodefend;
    }
}

