/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.core;

import java.io.Serializable;
import java.util.Vector;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.Player;

public class Continent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String idString;
    private String name;
    private int color;
    private int armyValue;
    private Vector territoriesContained = new Vector();

    public Continent(String id, String n, int noa, int c) {
        this.idString = id;
        this.name = n;
        this.color = c;
        this.armyValue = noa;
    }

    public String toString() {
        if (this.armyValue != 0) {
            return this.idString + " [" + this.armyValue + "]";
        }
        return this.idString;
    }

    public String getIdString() {
        return this.idString;
    }

    public void setIdString(String a) {
        this.idString = a;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String a) {
        this.name = a;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int a) {
        this.color = a;
    }

    public int getArmyValue() {
        return this.armyValue;
    }

    public void setArmyValue(int a) {
        this.armyValue = a;
    }

    public boolean isOwned(Player p) {
        int ownedByPlayer = 0;
        for (int c = 0; c < this.territoriesContained.size(); ++c) {
            if (((Country)this.territoriesContained.elementAt(c)).getOwner() != p) continue;
            ++ownedByPlayer;
        }
        return ownedByPlayer == this.territoriesContained.size();
    }

    public Player getOwner() {
        Player owner = ((Country)this.territoriesContained.elementAt(0)).getOwner();
        for (int c = 1; c < this.territoriesContained.size(); ++c) {
            if (((Country)this.territoriesContained.elementAt(c)).getOwner() == owner) continue;
            owner = null;
            break;
        }
        return owner;
    }

    public Vector getTerritoriesContained() {
        return this.territoriesContained;
    }

    public void addTerritoriesContained(Country t) {
        this.territoriesContained.add(t);
    }

    public boolean equals(Object o) {
        return o != null && o instanceof Continent && ((Continent)o).name.equals(this.name) && ((Continent)o).idString.equals(this.idString) && ((Continent)o).armyValue == this.armyValue;
    }
}

