
/* ********************************************************************* */
/* * 
                                                                 * */
/* * Copyright (c) 2010 Dipl.-Ing. Dirk Krause
                        * */
/* * 
                                                                 * */
/* * All rights reserved.
                                             * */
/* * 
                                                                 * */
/* * Redistribution and use in source and binary forms,
               * */
/* * with or without modification, are permitted provided
             * */
/* * that the following conditions are met:
                           * */
/* * 
                                                                 * */
/* * * Redistributions of source code must retain the above
           * */
/* *   copyright notice, this list of conditions and the
              * */
/* *   following disclaimer.
                                          * */
/* * * Redistributions in binary form must reproduce the above 
       * */
/* *   opyright notice, this list of conditions and the following
     * */
/* *   disclaimer in the documentation and/or other materials
         * */
/* *   provided with the distribution.
                                * */
/* * * Neither the name of Dirk Krause nor the names of
               * */
/* *   contributors may be used to endorse or promote
                 * */
/* *   products derived from this software without specific
           * */
/* *   prior written permission.
                                      * */
/* * 
                                                                 * */
/* * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
           * */
/* * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
      * */
/* * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
         * */
/* * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
         * */
/* * DISCLAIMED.
                                                      * */
/* * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
         * */
/* * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
            * */
/* * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
          * */
/* * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
         * */
/* * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
         * */
/* * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
        * */
/* * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
        * */
/* * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
          * */
/* * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
             * */
/* * DAMAGE.
                                                          * */
/* *                                                                   * */
/* ********************************************************************* */

#line 37 "kwt4.ctr"



/**	@file	kwt4.c	Support functions for kwintool, wide char strings.
*/


#include "kwintool.h"




#line 48 "kwt4.ctr"




int
wstr_is_whsp(WCHAR c)
{
  int back = 0;
  switch(c) {
    case L' ': case L'\t': case L'\r': case L'\n': {
      back = 1;
    } break;
  }
  return back;
}



WCHAR *
wstr_start(WCHAR const *s)
{
  WCHAR *back = NULL;
  WCHAR c;
  WCHAR const *ptr;
  
  ptr = s;
  while((*ptr) && (!back)) {
    c = *ptr;
    if(!wstr_is_whsp(c)) {
      back = (WCHAR *)ptr;
    }
    ptr++;
  } 
  return back;
}



WCHAR *
wstr_next(WCHAR *s)
{
  WCHAR *back = NULL;
  WCHAR *p1, *p2;
  
  p1 = wstr_start(s);
  if(p1) {
    p2 = NULL;
    while((*p1) && (p2 == NULL)) {
      if(wstr_is_whsp(*p1)) {
        p2 = p1;
      }
      p1++;
    }
    if(p2) {
      *(p2++) = L'\0';
      back = wstr_start(p2);
    }
  } 
  return back;
}



int
wstr_chomp(WCHAR *s)
{
  int back = 0;
  WCHAR c, *sptr, *ptr;
  
  c = *s;
  if(wstr_is_whsp(c)) {
    sptr = NULL; ptr = s;
    while((*ptr) && (!(sptr))) {
      c = *ptr;
      if(!wstr_is_whsp(c)) {
        sptr = ptr;
      }
      ptr++;
    }
    if(sptr) { ptr = s; while(*sptr) { *(ptr++) = *(sptr++); } *ptr = L'\0'; }
    else { s[0] = L'\0'; }
  }
  sptr = NULL; ptr = s;
  while(*ptr) {
    c = *ptr;
    if(wstr_is_whsp(c)) {
      if(!sptr) { sptr = ptr; }
    } else {
      sptr = NULL;
      back = 1;		/* at least one non-space found */
    }
    ptr++;
  }
  if(sptr) { *sptr = L'\0'; }
  
  return back;
}



int
wstr_array_index(WCHAR const * const *a, WCHAR const *s)
{
  int back = -1;
  WCHAR const * const *ptr; int i;
  
  ptr = a; i = 0;
  while((*ptr != NULL) && (back == -1)) {
    if(wcscmp(*ptr, s) == 0) {
      back = i;
    }
    ptr++; i++;
  } 
  return back;
}



WCHAR *
wstr_dup(WCHAR const *s)
{
  WCHAR *back = NULL;
  size_t l;
  if(s) {
    l = 1 + wcslen(s);
    l = l * sizeof(WCHAR);
    back = (WCHAR *)LocalAlloc((LMEM_FIXED | LMEM_ZEROINIT), (UINT)l);
    if(back) {
      wcscpy(back, s);
    }
  }
  return back;
}





