/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	dkstrdc.c	Delete comments from strings.
*/


#include "dk.h"




#line 48 "dkstrdc.ctr"




/*
  This file was generated by genau.
  You should not apply changes to this file because they
  may be overwritten by the next run of genau.
*/
#ifndef DELCOMM_INCLUDED
#define DELCOMM_INCLUDED

/* states    */
#define       S_BS 1
#define     S_COMM 6
#define       S_DQ 4
#define     S_DQBS 5
#define       S_SQ 2
#define     S_SQBS 3
#define    S_START 0

/* inputs    */
#define       I_BS 3
#define     I_COMM 4
#define       I_DQ 2
#define   I_NORMAL 0
#define       I_SQ 1

/* outputs   */
#define  O_COMMENT 1
#define O_CONTINUE 0

/* functions */

#if defined(__cplusplus)
extern "C" {
#endif

static
int delcomm_rules DK_PR((int *s, int i));
static
void delcomm_reset DK_PR((int *s));

#if defined(__cplusplus)
}
#endif


#endif
/*
  This file was generated by genau.
  You should not apply changes to this file because they
  may be overwritten by the next run of genau.
*/




/**	Reset the state machine.
	@param	s	Pointer to state variable.
*/
static
void delcomm_reset DK_P1(int *, s)
{
if(s) { *s = S_START; }
}



/**	State transition function.
	@param	s	Pointer to state variable.
	@param	i	Input value.
	@return	Output value.
*/
static
int delcomm_rules DK_P2(int *, s, int, i)
{
  int n, o;
  o = O_CONTINUE;
  if(s) {
    n = *s; o = O_CONTINUE;
    switch(*s) {
      case S_BS : {
            n = S_START; o = O_CONTINUE;
      } break;
      case S_COMM : {
            n = S_COMM; o = O_CONTINUE;
      } break;
      case S_DQ : {
        switch(i) {
          case I_BS : {
            n = S_DQBS; o = O_CONTINUE;
          } break;
          case I_DQ : {
            n = S_START; o = O_CONTINUE;
          } break;
        }
      } break;
      case S_DQBS : {
            n = S_DQ; o = O_CONTINUE;
      } break;
      case S_SQ : {
        switch(i) {
          case I_BS : {
            n = S_SQBS; o = O_CONTINUE;
          } break;
          case I_SQ : {
            n = S_START; o = O_CONTINUE;
          } break;
        }
      } break;
      case S_SQBS : {
            n = S_SQ; o = O_CONTINUE;
      } break;
      case S_START : {
        switch(i) {
          case I_BS : {
            n = S_BS; o = O_CONTINUE;
          } break;
          case I_COMM : {
            n = S_COMM; o = O_COMMENT;
          } break;
          case I_DQ : {
            n = S_DQ; o = O_CONTINUE;
          } break;
          case I_SQ : {
            n = S_SQ; o = O_CONTINUE;
          } break;
        }
      } break;
    }
    *s = n;
  }
  return o;
}



void
dkstr_delcomm DK_P2(char *, str, char, c)
{
  int au; int cc; char *ptr; int ic;
  if(str) {
    delcomm_reset(&au);
    ptr = str; cc = 1;
    while(cc) {
      if(*ptr) {
	if(*ptr == c) {
	  ic = I_COMM;
	} else {
	  ic = I_NORMAL;
	  if(*ptr == '\\') { ic = I_BS; }
	  if(*ptr == '\'') { ic = I_SQ; }
	  if(*ptr == '"')  { ic = I_DQ; }
	}
	ic = delcomm_rules(&au, ic);
	if(ic == O_COMMENT) {
	  *ptr = '\0'; cc = 0;
	}
      } else {
	cc = 0;
      }
      ptr++;
    }
  }
}

#if defined(DELCOMM_MAIN)

static char *test_strings[] = {
  "test mit \"abcde\" # 12345",
  "test mit \"abc\'de\" # 12345",
  "test mit \'abc\"de\' # 12345",
  "test mit \"#abcde\" # abcde",
  "test mit \'a\"bc#de\' test #abcde",
  NULL
};

void main(void)
{
  char **ptr;
  ptr = test_strings;
  while(*ptr) {
    printf("Unmodified: %s\n", *ptr);
    dkstr_delcomm(*ptr, '#');
    printf("  Modified: %s\n", *ptr);
    ptr++;
  }
}

#endif



