#include <dk.h>

#include <stdio.h>
#if DK_HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include <dkmem.h>
#include <dkapp.h>

static int exval = 1;

static dk_app_t *app = NULL;

static char groupname[] = { "testprog" };

static char tablename[] = { "hello" };

static char **msg = NULL;

static dk_key_value_t kv[] = {
  { "/m/00", "Hello world!" },
  { "/m/01", "Goodbye world!" }
};
static size_t szkv = sizeof(kv)/sizeof(dk_key_value_t);

int main(int argc, char *argv[])
{
  app = dkapp_open_ext1(argc, argv, groupname, DK_SYSCONFDIR, 0, 0);
  if(app) {
    msg = dkapp_find_key_value(app, kv, szkv, tablename);
    if(msg) {
      printf("%s\n", msg[0]);
      printf("%s\n", msg[1]);
      exval = 0;
      dk_delete(msg);
    } else {
      /* ERROR: Failed to obtain strings. */
    }
    dkapp_close(app); app = NULL;
  } else {
    /* ERROR: Failed to open application. */
  }
  exit(exval);
  return exval;
}


