/*
Copyright (c) 2001-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	klpq.c	The klpq program.
*/



#include <dk.h>
#include <dkmem.h>
#include <dkstr.h>
#include <dkapp.h>
#include <dktcpip.h>

#if DK_HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include <dktypes.h>

#include <yalc.h>
#include <dklic.h>


#line 60 "klpq.ctr"




/**	Application.
*/
dk_app_t *app = NULL;



/**	System configuration directory.
*/
static char sysconfdir[] = { DK_SYSCONFDIR };



/**	Program group name.
*/
static char prg_group_name[] = { "dktools" };



/**	Type definition necessary to use sizeof() operator.
*/
typedef char *PCHAR;



/**	Default help text, printed if help text file is not found.
*/
static char *help_text[] = {
  "",
  "klpq [-a] [-s] [-l | -L] [-f] [-t <secs>] [-S <server>] [-P <printer>] [<jobs>]",
  "",
  "-a         show queue for all printers",
  "-s         show queue status only",
  "-l         use long output format",
  "-L         use very long output format (LPRng print servers only)",
  "-f         remove filter status messages",
  "-t         show queue periodically all <secs> seconds",
  "-S         connect to the specified server",
  "-P         show queue for <printer>",
  "<jobs>     restrict output to given job-id's (optional)",
  "",
  NULL
};



/**	Long options.
*/
static char *long_options[] = {
  /*  0 */	"a$ll",
  /*  1 */	"st$atus",
  /*  2 */	"l$ong-output",
  /*  3 */	"very$-long-output",
  /*  4 */	"rem$ove-filter-status",
  /*  5 */	"rep$eat",
  /*  6 */	"s$erver",
  /*  7 */	"p$rinter",
  /*  8 */	"h$elp",
  /*  9 */	"v$ersion",
  NULL
};



/**	Printer name: All printers.
*/
static char all[] = { "all" };



/**	Run normally or print help/version.
	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
	@return	1 on success, 0 on error.
*/
static
int
run DK_P2(int, argc, char **, argv)
{
  int back = 0;
  char *printer_name, *server_name, *pchr, **arguments, **lfdptr;
  char **licptr;
  int    args_used, i;
  int    verbosity, max_verbosity, short_status_line;
  int    periodically, sleep_time, remove_done_jobs;
  int    all_wanted, version_wanted, help_wanted, x;
  yalc_rq_t *rq;

  verbosity = max_verbosity = short_status_line =
  periodically = sleep_time = all_wanted = remove_done_jobs =
  version_wanted = help_wanted = 0;
  printer_name = server_name = NULL;
  rq = yalc_new();
  if(rq) {
    arguments = dk_new(PCHAR,argc);
    if(arguments) {
      for(i = 0; i < argc; i++) {
	arguments[i] = NULL;
      }
      args_used = 0;
      i = 1; lfdptr = argv; lfdptr++;
      while(i < argc) {
	pchr = *lfdptr;
	if(*pchr == '-') {
	  pchr++;
	  switch(*pchr) {
	    case '-' : {
	      char *valptr; int whichoption, x;
	      
	      pchr++; 
              valptr = dkstr_chr(pchr, '=');
	      if(valptr) { *(valptr++) = (char)0; }
	      whichoption = dkstr_array_abbr(long_options, pchr, '$', 0);
	      
	      switch(whichoption) {
	        case 0 : {
		  
		  if(valptr) {
		    all_wanted = (dkstr_is_on(valptr) ? 1 : 0);
		  } else {
		    all_wanted = 1;
		  }
		} break;
		case 1 : {
		  
		  if(valptr) {
		    short_status_line = (dkstr_is_on(valptr) ? 1 : 0);
		  } else {
		    short_status_line = 1;
		  }
		} break;
		case 2 : {
		  
		  if(valptr) {
		    if(sscanf(valptr, "%d", &x) == 1) {
		      verbosity = x;
		    } else {
		      verbosity = (dkstr_is_on(valptr) ? 1 : 0);
		    }
		  } else {
		    verbosity++;
		  }
		} break;
		case 3 : {
		  
		  if(valptr) {
		    max_verbosity = (dkstr_is_on(valptr) ? 1 : 0);
		  } else {
		    max_verbosity = 1;
		  }
		} break;
		case 4 : {
		  
		  /* remove_filter_status = 1; */
		} break;
		case 5 : {
		  
		  if(valptr) {
		    if(sscanf(valptr, "%d", &x) == 1) {
		      periodically = 1; sleep_time = x;
		    } else {
		      if(dkstr_is_on(valptr)) {
		        periodically = 1; sleep_time = 15;
		      } else {
		        periodically = sleep_time = 0;
		      }
		    }
		  } else {
		    periodically = 1; sleep_time = 15;
		  }
		} break;
		case 6 : {
		  
		  if(valptr) { server_name = valptr; }
		} break;
		case 7 : {
		  
		  if(valptr) { printer_name = valptr; }
		} break;
		case 8 : {
		  
		  if(valptr) {
		    help_wanted = (dkstr_is_on(valptr) ? 1 : 0);
		  } else {
		    help_wanted = 1;
		  }
		} break;
		case 9 : {
		  
		  if(valptr) {
		    version_wanted = (dkstr_is_on(valptr) ? 1 : 0);
		  } else {
		    version_wanted = 1;
		  }
		} break;
	      }
	    } break;
	    case 'd' : {
	      remove_done_jobs = 1;
	    } break;
	    case 'a' : {
	      all_wanted = 1;
	    } break;
	    case 'l' : {
	      verbosity++;
	    } break;
	    case 'L' : {
	      max_verbosity = 1;
	    } break;
	    case 'H' :
	    case 'S' : {
	      pchr++;
	      if(!(*pchr)) {
		i++; lfdptr++;
		if(i < argc) {
		  pchr = *lfdptr;
		}
	      }
	      if(*pchr) {
		server_name = pchr;
	      }
	    } break;
	    case 'P' : {
	      pchr++;
	      if(!(*pchr)) {
		i++; lfdptr++;
		if(i < argc) {
		  pchr = *lfdptr;
		}
	      }
	      if(*pchr) {
		printer_name = pchr;
	      }
	    } break;
	    case 's' : {
	      short_status_line = 1;
	    } break;
	    case 't' : {
	      pchr++;
	      if(!(*pchr)) {
		i++; lfdptr++;
		if(i < argc) {
		  pchr = *lfdptr;
		}
	      }
	      if(*pchr) {
		if(sscanf(pchr, "%d", &x) == 1) {
		  periodically = 1;
		  sleep_time = x;
		}
	      }
	    } break;
	    case 'v' :
	    case 'V' : {
	      version_wanted = 1;
	    } break;
	    case 'h' : {
	      help_wanted = 1;
	    } break;
	    /*
	    case 'f' : {
	      remove_filter_status = 1;
	    } break;
	    */
	  }
	} else {
	  arguments[args_used] = dkstr_dup(pchr);
	  if(arguments[args_used]) {
	    args_used++;
	  } else {
	    dkapp_err_memory(app,sizeof(char),(1+strlen(pchr)));
	  }
	}
	i++; lfdptr++;
      }
      if(version_wanted || help_wanted) {
        if(version_wanted) {
	  printf("\n");
	  {
	    char **vptr;
	    vptr = yalc_get_version();
	    if(vptr) {
	      while(*vptr) {
	        printf("%s\n", *(vptr++));
	      }
	    }
	  }
	  printf("\nLibraries used:\n\n");
	  licptr = dklic_get();
	  while(*licptr) {
	    printf("%s\n", *(licptr++));
	  }
	  printf("\n");
	}
	if(help_wanted) {
	  dkapp_help(app, "klpq.txt", help_text);
	}
	back = 1;
      } else {
	yalc_set_lpq(
	  rq,
	  max_verbosity,
	  verbosity,
	  short_status_line,
	  periodically,
	  sleep_time,
	  remove_done_jobs
	);
	yalc_set_printer(
	  rq,
	  (printer_name ? (printer_name) : (all_wanted ? all : NULL))
	);
	yalc_set_server(
	  rq,
	  server_name
	);
	yalc_set_app(
	  rq,
	  app
	);
	yalc_set_args(
	  rq,
	  args_used,
	  arguments
	);
	back = yalc_run(rq);
      }
      for(i = 0; i < argc; i++) {
	pchr = arguments[i];
	if(pchr) { dk_delete(pchr); }
	arguments[i] = NULL;
      }
      dk_delete(arguments);
    } else {
      dkapp_err_memory(app, sizeof(PCHAR), argc);
    }
    yalc_delete(rq); rq = NULL;
  } else {
    dkapp_err_memory(app, sizeof(yalc_rq_t), 1);
  }
  return back;
}



/**	The main() function of the klpq program.
	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
	@return	0 on success, any other value indicates an error.
*/
#if DK_HAVE_PROTOTYPES
int main(int argc, char *argv[])
#else
int main(argc, argv) int argc; char *argv[];
#endif
{
  int back = 0;
  int xargc;
  char **xargv;
  
#line 422 "klpq.ctr"

  app = dkapp_open_ext1(argc, argv, prg_group_name, sysconfdir, 0, 0);
  if(app) {
    if(dktcpip_start()) {
      xargc = dkapp_get_argc(app);
      xargv = dkapp_get_argv(app);
      back = run(xargc, xargv);
      dktcpip_end();
    } else {
      dkapp_err_tcpip(app);
    }
    dkapp_close(app); app = NULL;
  } else {
    fprintf(stderr, "ERROR: Not enough memory!\n"); fflush(stderr);
  }
  back = (back ? 0 : 1);
  
  
#line 439 "klpq.ctr"

  exit(back); return back;
}


