/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	dkbifja.c	JPEG analysis module.
*/



/**	Inside the dkbifja module.
*/
#define DKBIFJA_C	1

#include "dkbif.h"
#include "dkbifi.h"

#line 51 "dkbifja.ctr"




/**	@defgroup	jpegspec	Special bytes in JPEG files. */
/*@{*/

#define	I_FF		0x00FF
#define	I_DHT		0x00C4
#define	I_DAC		0x00CC
#define	I_RST0		0x00D0
#define	I_RST1		0x00D1
#define	I_RST2		0x00D2
#define	I_RST3		0x00D3
#define	I_RST4		0x00D4
#define	I_RST5		0x00D5
#define	I_RST6		0x00D6
#define	I_RST7		0x00D7
#define I_SOI		0x00D8
#define I_EOI		0x00D9
#define I_SOS		0x00DA
#define I_DQT		0x00DB
#define I_DNL		0x00DC
#define I_DRI		0x00DD
#define I_DHP		0x00DE
#define I_EXP		0x00DF
#define I_APP0		0x00E0
#define I_APP1		0x00E1
#define I_APP2		0x00E2
#define I_APP3		0x00E3
#define I_APP4		0x00E4
#define I_APP5		0x00E5
#define I_APP6		0x00E6
#define I_APP7		0x00E7
#define I_APP8		0x00E8
#define I_APP9		0x00E9
#define I_APP10		0x00EA
#define I_APP11		0x00EB
#define I_APP12		0x00EC
#define I_APP13		0x00ED
#define I_APP14		0x00EE
#define I_APP15		0x00EF
#define I_JPG0		0x00F0
#define I_JPG1		0x00F1
#define I_JPG2		0x00F2
#define I_JPG3		0x00F3
#define I_JPG4		0x00F4
#define I_JPG5		0x00F5
#define I_JPG6		0x00F6
#define I_JPG7		0x00F7
#define I_JPG8		0x00F8
#define I_JPG9		0x00F9
#define I_JPG10		0x00FA
#define I_JPG11		0x00FB
#define I_JPG12		0x00FC
#define I_JPG13		0x00FD
#define I_COM		0x00FE
#define I_TEM		0x0001
/*@}*/



/**	The sequence 0xFF 0xD8.
*/
static unsigned char ffd8[] = { 0xFF, 0xD8 };


/**	Print one byte.
*/
#define PRINT_BYTE if(a->is_printing) { if(a->os) { dkstream_write(a->os, &c, 1); } }



int
dkbif_jfif_get_sof DK_P2(dk_bif_sof_t,bits, int,sof)
{
  int back = 0;
  unsigned mask = 0;
  switch(sof) {
    case DKBIF_I_SOF0: { mask = DKBIF_JFIF_SOF0; } break;
    case DKBIF_I_SOF1: { mask = DKBIF_JFIF_SOF1; } break;
    case DKBIF_I_SOF2: { mask = DKBIF_JFIF_SOF2; } break;
    case DKBIF_I_SOF3: { mask = DKBIF_JFIF_SOF3; } break;
    case DKBIF_I_SOF5: { mask = DKBIF_JFIF_SOF5; } break;
    case DKBIF_I_SOF6: { mask = DKBIF_JFIF_SOF6; } break;
    case DKBIF_I_SOF7: { mask = DKBIF_JFIF_SOF7; } break;
    case DKBIF_I_SOF8: { mask = DKBIF_JFIF_SOF8; } break;
    case DKBIF_I_SOF9: { mask = DKBIF_JFIF_SOF9; } break;
    case DKBIF_I_SOF10: { mask = DKBIF_JFIF_SOF10; } break;
    case DKBIF_I_SOF11: { mask = DKBIF_JFIF_SOF11; } break;
    case DKBIF_I_SOF13: { mask = DKBIF_JFIF_SOF13; } break;
    case DKBIF_I_SOF14: { mask = DKBIF_JFIF_SOF14; } break;
    case DKBIF_I_SOF15: { mask = DKBIF_JFIF_SOF15; } break;
  }
  if(bits & mask) {
    back = 1;
  }
  return back;
}



dk_bif_sof_t
dkbif_jfif_set_sof DK_P2(dk_bif_sof_t,old, int,sof)
{
  unsigned back;
  back = old;
  switch(sof) {
    case DKBIF_I_SOF0: { back = old | DKBIF_JFIF_SOF0; } break;
    case DKBIF_I_SOF1: { back = old | DKBIF_JFIF_SOF1; } break;
    case DKBIF_I_SOF2: { back = old | DKBIF_JFIF_SOF2; } break;
    case DKBIF_I_SOF3: { back = old | DKBIF_JFIF_SOF3; } break;
    case DKBIF_I_SOF5: { back = old | DKBIF_JFIF_SOF5; } break;
    case DKBIF_I_SOF6: { back = old | DKBIF_JFIF_SOF6; } break;
    case DKBIF_I_SOF7: { back = old | DKBIF_JFIF_SOF7; } break;
    case DKBIF_I_SOF8: { back = old | DKBIF_JFIF_SOF8; } break;
    case DKBIF_I_SOF9: { back = old | DKBIF_JFIF_SOF9; } break;
    case DKBIF_I_SOF10: { back = old | DKBIF_JFIF_SOF10; } break;
    case DKBIF_I_SOF11: { back = old | DKBIF_JFIF_SOF11; } break;
    case DKBIF_I_SOF13: { back = old | DKBIF_JFIF_SOF13; } break;
    case DKBIF_I_SOF14: { back = old | DKBIF_JFIF_SOF14; } break;
    case DKBIF_I_SOF15: { back = old | DKBIF_JFIF_SOF15; } break;
  }
  return back;
}



/**	Special handling for JPEGs create by Adobe software.
*/
static char str_adobe[] = { "Adobe" };


void
dkbif_jfif_analyze DK_P1(dk_bif_jfif_analyze_t *,a)
{
  char buffer[512], skip_bytes[246], c, *cptr;
  size_t br = 0;	/* bytes read */
  size_t bu = 0;	/* bytes used */
  size_t skb_used = 0;	/* skip_bytes used */
  int    skb_opcode=0;	/* opcode for handling skipped bytes */
  int    state = 0, must_handle_skipped_bytes = 0;
  unsigned bytes_to_skip = 0U, u1 = 0U, u2 = 0U, lgt = 0U;
  unsigned char uc = 0x00; unsigned u = 0U; int i = 0;
  unsigned long image_level = 0UL, found_level = 0UL;
  int cc = 0;
  
  /* initialize results */
  a->is_jfif = 0;
  a->vers_major = 0x00; a->vers_minor = 0x00; a->dpi_setting = 0x00;
  a->adobe_marker_found = 0x00;
  a->bpc = 0x00; a->components = 0x00; a->width = 0; a->height = 0;
  a->xres = 0; a->yres = 0; a->used_sofs = 0;
  a->n_sofs = 0; a->n_images = 0;
  cc = 1;
  found_level = image_level = 0U;
  state = must_handle_skipped_bytes = 0; bytes_to_skip = 0;
  while((cc == 1) && (a->is_jfif < 2)) {
    br = fread(buffer, 1, sizeof(buffer), a->inputfile);
    if(br > 0) {
      cptr = buffer; bu = 0;
      while((bu < br) && (cc) && (a->is_jfif < 2)) {
        c = *(cptr++);
	bu++; uc = (unsigned char)c; u = (unsigned)uc; i = (int)u;
	if(bytes_to_skip) {
	  if(must_handle_skipped_bytes) {
	    if(skb_used < (sizeof(skip_bytes) - 1)) {
	      skip_bytes[skb_used++] = c;
	    }
	  }
	  bytes_to_skip--;
	  if(bytes_to_skip == 0) {
	    if(must_handle_skipped_bytes) {
	      skip_bytes[skb_used] = '\0';
	      switch(skb_opcode) {
	        case I_APP14: {
		  if(skb_used >= 12) {
		    if(strncmp(skip_bytes, str_adobe, 5) == 0) {
		      a->adobe_marker_found = 0x01;
		    }
		  }
		} break;
	      }
	    }
	  }
	} else {
	  switch(state) {
	    case 0: {	/* initial state */
	      if(uc == 0xFF) { state = 1; }
	    } break;
	    case 1: {	/* 0xFF _ */
	      switch(i) {
	        case I_SOI:	{
		  state = 2;
		  image_level++;
		  a->n_images += 1;
		} break;
		case 0x00FF:	{ state = 1; } break;
		default:	{ state = 0; } break;
	      }
	    } break;
	    case 2: {	/* FF D8 _ */
	      if(uc == 0xFF) { state = 3; }
	      else {
	        a->is_jfif = 2;			
	      }
	    } break;
	    case 3: {	/* FF D8 FF _ */
	      if(uc == 0xE0) { state = 4; }
	      else {
	        if((uc > 0xE0) && (uc < 0xF0)) {
		  state = 32;
		  /* additional APPn markers */
		} else {
	          a->is_jfif = 2;
		}
	      }
	    } break;
	    case 4: {	/* FF D8 FF E0 _ */
	      u1 = ((u << 8) & 0xFF00); state = 5;
	    } break;
	    case 5: {	/* FF D8 FF E0 l1 _ */
	      u2 = (u & 0xFF); lgt = (u1 | u2); state = 6;
	      if(lgt < 14) {
	        a->is_jfif = 2;			
	      }
	    } break;
	    case 6: {	/* FF D8 FF E0 l1 l2 _ */
	      if(c == 'J') { state = 7; }
	      else {
	        a->is_jfif = 2;			
	      }
	    } break;
	    case 7: {
	      if(c == 'F') { state = 8; }
	      else {
	        a->is_jfif = 2;			
	      }
	    } break;
	    case 8: {
	      if(c == 'I') { state = 9; }
	      else {
	        a->is_jfif = 2;			
	      }
	    } break;
	    case 9: {
	      if(c == 'F') { state = 10; }
	      else {
	        a->is_jfif = 2;			
	      }
	    } break;
	    case 10: {
	      if(uc == 0x00) { state = 11; }
	      else {
	        a->is_jfif = 2;			
	      }
	    } break;
	    case 11: {
	      a->vers_major = uc; state = 12;
	    } break;
	    case 12: {
	      a->vers_minor = uc; state = 13;
	    } break;
	    case 13: {
	      a->dpi_setting = uc; state = 14;
	    } break;
	    case 14: {
	      u1 = ((u << 8) & 0xFF00); state = 15;
	    } break;
	    case 15: {
	      u2 = (u & 0x00FF); a->xres = (u1 | u2); state = 16;
	    } break;
	    case 16: {
	      u1 = ((u << 8) & 0xFF00); state = 17;
	    } break;
	    case 17: {
	      u2 = (u & 0x00FF); a->yres = (u1 | u2); state = 18;
	      bytes_to_skip = lgt - 14;
	    } break;
	    case 18: {
	      if(uc == 0xFF) state = 19;
	    } break;
	    case 19: {
	      must_handle_skipped_bytes = 0;
	      skb_opcode = i;
	      switch(i) {
	        case 0:		{ state = 18; }	break;
		case 0x00FF:	{ state = 19; }	break;
		case I_SOI:	{
		  image_level++; state = 18;
		  a->n_images += 1UL;
		} break;
		case I_EOI:	{
		  if(image_level > 0UL) { image_level--; }
		  state = 18;
		} break;
		case I_RST0: case I_RST1: case I_RST2: case I_RST3:
		case I_RST4: case I_RST5: case I_RST6: case I_RST7:
		case I_TEM: {
		  state = 18;
		} break;
		case DKBIF_I_SOF15: case DKBIF_I_SOF14: case DKBIF_I_SOF13:
		case DKBIF_I_SOF11: case DKBIF_I_SOF10: case DKBIF_I_SOF9:
		case DKBIF_I_SOF8: case DKBIF_I_SOF7: case DKBIF_I_SOF6:
		case DKBIF_I_SOF5: case DKBIF_I_SOF3: case DKBIF_I_SOF2: {
		  if(a->is_jfif < 2) { a->is_jfif = 1; }
		}
		case DKBIF_I_SOF1: case DKBIF_I_SOF0: {
		  a->used_sofs = dkbif_jfif_set_sof(a->used_sofs, i);
		  a->n_sofs += 1UL;
		  state = 30;
		  if((found_level == 0) || (image_level <= found_level)) {
		    state = 20;
		  }
		} break;
		case I_APP14: {
		  state = 30; skb_used = 0;
		  skb_opcode = i; must_handle_skipped_bytes = 1;
		} break;
		default: {
		  state = 30;
		} break;
	      }
	    } break;
	    case 20: {
	      u1 = ((u << 8) & 0xFF00); state = 21;
	    } break;
	    case 21: {
	      u2 = (u & 0x00FF); lgt = (u1 | u2); state = 22;
	      if(lgt < 8) {
	        a->is_jfif = 2;			
	      }
	    } break;
	    case 22: {
	      a->bpc = uc; state = 23;
	    } break;
	    case 23: {
	      u1 = ((u << 8) & 0xFF00); state = 24;
	    } break;
	    case 24: {
	       u2 = (u & 0x00FF); a->height = (u1 | u2); state = 25;
	    } break;
	    case 25: {
	      u1 = ((u << 8) & 0xFF00); state = 26;
	    } break;
	    case 26: {
	      u2 = (u & 0x00FF); a->width = (u1 | u2); state = 27;
	    } break;
	    case 27: {
	      a->components = uc; state = 18;
	      bytes_to_skip = lgt - 8;
	    } break;
	    case 30: {
	      /* read length to skip */
	      u1 = ((u << 8) & 0xFF00); state = 31;
	    } break;
	    case 31: {
	      u2 = (u & 0x00FF); lgt = (u1 | u2);
	      state = 18;
	      if(lgt < 2) {
	        a->is_jfif = 2;			
	      }
	      bytes_to_skip = lgt - 2;
	    } break;
	    case 32: {
	      u1 = ((u << 8) & 0xFF00);
	      state = 33;
	    } break;
	    case 33: {
	      u2 = (u & 0x00FF);
	      lgt = (u1 | u2);
	      state = 2;
	      if(lgt < 2) {
	        a->is_jfif = 2;
	      } else {
	        bytes_to_skip = lgt - 2;
	      }
	    } break;
	  }
	}
      }
    } else {
      cc = 0;
    }
  }
  if(state != 18) {		
    a->is_jfif = 2;
  }
  if(a->width == 0) {		
    a->is_jfif = 2;
  }
  if(a->height == 0) {		
    a->is_jfif = 2;
  }
  if(a->bpc != 8) {		
    a->is_jfif = 2;
  }
  if(a->components != 3) {
    if(a->components != 4) {
      if(a->components != 1) {
        a->is_jfif = 2;		
      }
    }
  }
  if(a->n_sofs != 1) {		
    a->is_jfif = 2;
  }
  if(a->n_images != 1) {	
    a->is_jfif = 2;
  }
  if(a->vers_major != 0x01) {	
    a->is_jfif = 2;
  }
  if(a->vers_minor < 0x01) {	
    /* a->is_jfif = 2; */
    
  }
  if(a->vers_minor > 0x02) {	
    a->is_jfif = 2;
  }
  
}


void
dkbif_jfif_transfer DK_P2(dk_stream_t *,ofs, FILE *,inf)
{
  unsigned char buffer[512], c, *cptr;
  size_t br, bu;
  int state, cc;

  cc = 1; state = 0;
  while(cc) {
    br = fread(buffer, 1, sizeof(buffer), inf);
    if(br > 0) {
      if(state == 5) {
        dkstream_write(ofs, (char *)buffer, br);
      } else {
        cptr = buffer; bu = 0;
	while(bu < br) {
	  c = *(cptr++); bu++;
	  switch(state) {
	    case 0: {
	      if(c == 0xFF) state = 1;
	    } break;
	    case 1: {
	      if(c == 0xD8) {
	        dkstream_write(ofs, (char *)ffd8, 2);
		state = 5;
		if(bu < br) {
		  dkstream_write(ofs, (char *)cptr, (br - bu));
		}
		bu = br;
	      } else {
	        if(c != 0xFF) state = 0;
	      }
	    } break;
	  }
	}
      }
    } else {
      cc = 0;
    }
  }
}



