#! /usr/bin/perl -w

# Copyright (C) 2010 by Dirk Krause
# All rights reserved.
# 
# Redistribution and use in source and binary forms,
# with or without modification, are permitted provided
# that the following conditions are met:
# 
# * Redistributions of source code must retain the above
#   copyright notice, this list of conditions and the
#   following disclaimer.
# * Redistributions in binary form must reproduce the above 
#   opyright notice, this list of conditions and the following
#   disclaimer in the documentation and/or other materials
#   provided with the distribution.
# * Neither the name of the Dirk Krause nor the names of
#   contributors may be used to endorse or promote
#   products derived from this software without specific
#   prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
# CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED.
# IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
# DAMAGE.

my @defs;
my $ndefs = 0;
my $i = 0;
my $n = 0;

if(open(INPUT, "<config.h.in")) {
  while(<INPUT>) {
    $line = $_; chomp $line;
    if($line =~ /^\s*\#\s*define\s+(\S+)\s+\S+\s*$/o) {
      $name = $1;
      $defs[$ndefs++] = "$name";
    }
  }
  close(INPUT);
  if(open(OUTPUT, ">dkconfig.c")) {
    print OUTPUT "#include <dkconfig.h>\n";
    print OUTPUT "#include <stdio.h>\n";
    print OUTPUT "#if DK_HAVE_UNISTD_H\n#include <unistd.h>\n#endif\n";
    print OUTPUT "#if DK_HAVE_STDLIB_H\n#include <stdlib.h>\n#endif\n";
    print OUTPUT "#if DK_HAVE_PROCESS_H\n#include <process.h>\n#endif\n\n";
    print OUTPUT "static char *config_options[] = {\n";
    print OUTPUT "\"#if !defined(DKCONFIG_INC)\",\n";
    print OUTPUT "\"#define DKCONFIG_INC 1\",\n\n";
    print OUTPUT "\"\",\n";
    for($i = 0; $i < $ndefs; $i++) {
      $n = $defs[$i];
      print OUTPUT "#if DK_$n\n";
      print OUTPUT "\"/*\\t\\t\\t\\t\\t+\\t$n */\",\n";
      print OUTPUT "\"#if !defined(DK_$n)\",\n";
      print OUTPUT "\"#define DK_$n 1\",\n";
      print OUTPUT "\"#endif\",\n";
      print OUTPUT "\"\",\n";
      print OUTPUT "#else\n";
      print OUTPUT "\"/*\\t\\t\\t\\t\\t-\\t$n */\",\n";
      print OUTPUT "\"#if defined(DK_$n)\",\n";
      print OUTPUT "\"#undef DK_$n\",\n";
      print OUTPUT "\"#endif\",\n";
      print OUTPUT "\"\",\n";
      print OUTPUT "#endif\n\n";
    }
	print OUTPUT "\"#if DK_HAVE_VOLATILE\",\n";
	print OUTPUT "\"#define DK_VOLATILE volatile\",\n";
	print OUTPUT "\"#else\",\n";
	print OUTPUT "\"#define DK_VOLATILE /* nix */\",\n";
	print OUTPUT "\"#endif\",\n\n";
	print OUTPUT "\"#if DK_HAVE_CONST\",\n";
	print OUTPUT "\"#define DK_CONST const\",\n";
	print OUTPUT "\"#else\",\n";
	print OUTPUT "\"#ifdef __cplusplus\",\n";
	print OUTPUT "\"#define DK_CONST const\",\n";
	print OUTPUT "\"#else\",\n";
	print OUTPUT "\"#define DK_CONST /* nix */\",\n";
	print OUTPUT "\"#endif\",\n";
	print OUTPUT "\"#endif\",\n";
    print OUTPUT "\"#endif\",\n";
	print OUTPUT "\"\",\n";
    print OUTPUT "\nNULL\n} ;\n";
    print OUTPUT "\n\n";
    print OUTPUT "int main(int argc, char *argv[])\n";
    print OUTPUT "{\n";
    print OUTPUT "  char **ptr;\n";
    print OUTPUT "  ptr = config_options;\n";
    print OUTPUT "  while(*ptr) {\n";
    print OUTPUT "    printf(\"\%s\\n\", *(ptr++));\n";
    print OUTPUT "  }\n";
    print OUTPUT "  exit(0); return 0;\n";
    print OUTPUT "}\n";
    close(OUTPUT);
  }
  if(open(OUTPUT, ">dkconftr.h")) {
    print OUTPUT "#ifndef DKCONFTR_INC\n";
    print OUTPUT "#define DKCONFTR_INC 1\n\n\n";
    for($i = 0; $i < $ndefs; $i++) {
      $n = $defs[$i];
      print OUTPUT "/* $n */\n";
      print OUTPUT "#if $n\n";
      print OUTPUT "#ifndef DK_$n\n";
      print OUTPUT "#define DK_$n 1\n";
      print OUTPUT "#endif\n";
      print OUTPUT "#else\n";
      print OUTPUT "#ifdef DK_$n\n";
      print OUTPUT "#undef DK_$n\n";
      print OUTPUT "#endif\n";
      print OUTPUT "#ifdef $n\n";
      print OUTPUT "#undef $n\n";
      print OUTPUT "#endif\n";
      print OUTPUT "#endif\n\n";
    }
    print OUTPUT "\n\n#endif\n/* ifndef DKCONFTR_INC */\n";
    close(OUTPUT);
  }
}
