package DKrause::Stream;

use 5.000000;
use strict;
use warnings;

require Exporter;

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use DKrause::Stream ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
	
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
	
);

our $VERSION = '0.01';

require XSLoader;
XSLoader::load('DKrause::Stream', $VERSION);

# Preloaded methods go here.

1;
__END__

=head1 NAME

DKrause::Stream - Perl extension for writing to a generic stream

=head1 SYNOPSIS

  use DKrause::Stream;
  $stream1 = DKrause::Stream::new("myfile.txt", "r", "plain");
  $stream2 = DKrause::Stream::newStdout();
  $stream3 = DKrause::Stream::newStderr();
  $stream4 = $stream1->filter('ascii85', 'flate');

  $stream1->close(); $stream2->close(); $stream3->close();


=head1 DESCRIPTION

The DKrause::Stream API allows to read from and write to plain files and
gzip/bzip2 compressed files.

The constructors new(filename, mode, compression),
newStdout() and newStderr() return a DKrause::Stream object reference.
The mode is the mode string as used in the C fopen() function.
The compression parameter may be ``plain'', ``gzip'' or ``bzip2''.

The puts(str) method puts a string to the stream.

The putsDouble(d) method adds the double value d to the stream.

The putsLong(l) method puts a long value to the stream.

The putsUnsignedLong(u) method puts an unsigned long value to the
stream.

The nl() method writes a newline to the stream.

The crnl() method writes a carriage return/newline combination to the stream.

The gets(sz) method reads a text line from the stream. The optional
sz parameter (default: 1024) specifies the expected maximum length of the
line.

The wbByte(b) method writes a binary byte to the stream.

The wbWord(w) method writes a word to the stream.

The wbUword(u) method writes an unsigned word to the stream.

The wbDword(d) method writes a double word to the stream.

The wbUdword(u) method writes an unsigned double word to the stream.

The wbString(s) method writes a string in binary for to the stream.

The rbByte() method reads an unsigned character from the stream.

The rbWord() method reads a binary word from the stream.

The rbUword() method reads an unsigned binary word from the stream.

The rbDword() method reads a binary double word from the stream.

The rbUdword() method reads an unsigned binary double word from the stream.

The rbString() method reads a binary string from the stream.

The getBytesWritten() method returns the number of bytes written to the
stream.

The setCrNl(f) method sets or resets the newline to carriage-newline
conversion flag.

The filter() method returns a new DKrause::Stream object on top of the
current stream. The new
object filters incoming data an writes the filter result data to the
underlaying stream. The arguments in this method are a list of filter
names: ``none'' (no filtering), ``buffered'' (write to underlaying stream
in fixed buffer size, except the final block),
``ascii85'' (binary to text conversion using ASCII-85-encoding),
``asciihex'' (binary to text conversion using ASCII-Hex-encoding,
``flate'' (flate compression), ``run-length'' (run-length compression
suitable for PostScript), ``lzw'' (LZW compression).
The lowest (last-to-apply) filter must be listed first, the upper-most
(first-to-apply) filter must be listed last.

The setFinalizing(f) method sets/resets the flag for writing a finalizer
at the end of filtered output.

To begin filtered output use the startChunk() method on the filter stream,
use endChunk() when data filtering is done to flush the buffers.



=head2 EXPORT

None by default.

=head1 AUTHOR

Dirk Krause, E<lt>krause@localdomainE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2010 by Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.

=cut
