;// Copyright (c) 2008, Dirk Krause
;// All rights reserved.
;// 
;// Redistribution and use in source and binary forms,
;// with or without modification, are permitted provided
;// that the following conditions are met:
;// 
;// * Redistributions of source code must retain the above
;//   copyright notice, this list of conditions and the
;//   following disclaimer.
;// * Redistributions in binary form must reproduce the above 
;//   opyright notice, this list of conditions and the following
;//   disclaimer in the documentation and/or other materials
;//   provided with the distribution.
;// * Neither the name of the Dirk Krause nor the names of
;//   other contributors may be used to endorse or promote
;//   products derived from this software without specific
;//   prior written permission.
;// 
;// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
;// CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
;// INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
;// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
;// DISCLAIMED.
;// IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
;// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
;// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
;// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
;// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
;// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
;// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
;// OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
;// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
;// DAMAGE.



MessageIdTypedef=DWORD

SeverityNames=(Success=0x0:STATUS_SEVERITY_SUCCESS
Informational=0x1:STATUS_SEVERITY_INFORMATIONAL
Error=0x3:STATUS_SEVERITY_ERROR
)

FacilityNames=(System=0x0:FACILITY_SYSTEM
)

LanguageNames=(English=0x409:MSG00409)



;// Category for RshDown
MessageId=0x1
SymbolicName=CAT_RSHDOWN
Language=English
RshDown
.



;// The RshDown service is up and running
MessageId=0x101
Severity=Informational
Facility=System
SymbolicName=MSG_STARTED
Language=English
The rshdown service is up and running.
.


;// No response from background thread
MessageId=0x102
Severity=Error
Facility=System
SymbolicName=MSG_BG_THREAD_NOT_RESPONDING
Language=English
The background thread did not respond to the stop event.
.

;// Stopped multiple times
MessageId=0x103
Severity=Error
Facility=System
SymbolicName=MSG_ALREADY_STOPPED
Language=English
The service was already stopped and resources were released.
.


;// Host not found
MessageId=0x104
Severity=Error
Facility=System
SymbolicName=MSG_HOST_NOT_FOUND
Language=English
Host "%1" was not found.
.

;// Host name too long
MessageId=0x105
Severity=Error
Facility=System
SymbolicName=MSG_HOST_NAME_TOO_LONG
Language=English
The host name "%1" is too long.
.

;// Not a number
MessageId=0x106
Severity=Error
Facility=System
SymbolicName=MSG_NOT_A_NUMBER
Language=English
"%1" is not a number.
.


;// Not a host:port
MessageId=0x107
Severity=Error
Facility=System
SymbolicName=MSG_NOT_HOST_AND_PORT
Language=English
"%1" is not a host:port information.
.


;// File is empty
MessageId=0x108
Severity=Error
Facility=System
SymbolicName=MSG_FILE_EMPTY
Language=English
File "%1" is empty.
.

;// Failed to open file
MessageId=0x109
Severity=Error
Facility=System
SymbolicName=MSG_FOPEN_FAILED
Language=English
Failed to open file "%1".
.

;// Data file not specified
MessageId=0x10A
Severity=Error
Facility=System
SymbolicName=MSG_FILE_NOT_SPECIFIED
Language=English
No data file name is available.
.

;// No local port specified in the registry
MessageId=0x10B
Severity=Error
Facility=System
SymbolicName=MSG_NO_LOCAL_PORT
Language=English
No local port number information is available.
.

;// No sender:port
MessageId=0x10C
Severity=Error
Facility=System
SymbolicName=MSG_NO_SENDER
Language=English
No sender (host:port) information is available.
.

;// Failed to open registry key
MessageId=0x10D
Severity=Error
Facility=System
SymbolicName=MSG_REGKEY_FAILED
Language=English
Failed to open the configuration registry key.
.

;// Service is going down
MessageId=0x10E
Severity=Informational
Facility=System
SymbolicName=MSG_GOING_DOWN
Language=English
The service is going down.
.

;// Failed to bind local address
MessageId=0x10F
Severity=Error
Facility=System
SymbolicName=MSG_BIND_FAILED
Language=English
Failed to bind local address.
.

;// socket failed
MessageId=0x110
Severity=Error
Facility=System
SymbolicName=MSG_SOCKET_FAILED
Language=English
Failed to create network socket.
.

;// WSAStartup failed
MessageId=0x111
Severity=Error
Facility=System
SymbolicName=MSG_WINSOCK_FAILED
Language=English
Failed to start TCP/IP subsystem.
.

;// Failed to obtain shutdown privilege
MessageId=0x112
Severity=Error
Facility=System
SymbolicName=MSG_PRIVILEGE_FAILED
Language=English
The process failed to obtain the SeShutdownPrivilege.
.

;// Failed to obtain current process token
MessageId=0x113
Severity=Error
Facility=System
SymbolicName=MSG_PROCESS_TOKEN
Language=English
The process failed to access the current process token.
.

;// Failed to obtain current process handle
MessageId=0x114
Severity=Error
Facility=System
SymbolicName=MSG_PROCESS_HANDLE
Language=English
The process failed to obtain the current process handle.
.

;// Shutdown initialized
MessageId=0x115
Severity=Informational
Facility=System
SymbolicName=MSG_SHUTDOWN_INITIALIZED
Language=English
A system shutdown was initialized.
.

;// Failed to initialize shutdown
MessageId=0x116
Severity=Error
Facility=System
SymbolicName=MSG_SHUTDOWN_FAILED
Language=English
The service was already stopped and resources were released.
.
