/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

#include "dk.h"
#include "dkmem.h"
#include "dksfc.h"
#include "dksf.h"
#include "dkstr.h"



#include <stdio.h>

#if DK_HAVE_STDLIB_H
#include <stdlib.h>
#endif
#if DK_HAVE_UNISTD_H
#include <unistd.h>
#endif
#if DK_HAVE_PROCESS_H
#include <process.h>
#endif
#if DK_HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#if DK_HAVE_PWD_H
#include <pwd.h>
#endif
#if DK_HAVE_GRP_H
#include <grp.h>
#endif




#line 69 "jhelp.ctr"




static char *command_names[] = {
  /*  0 */	"platform",
  NULL
};



static char *platform_strings[] = {
#if DK_HAVE_FNCASEINS
  "filenames.case-sensitive no",
#else
  "filenames.case-sensitive yes",
#endif
#if DK_HAVE_DOS_DRIVE_LETTER
  "filenames.driveletter yes",
#else
  "filenames.driveletter no",
#endif
#if DK_HAVE_FEATURE_BACKSLASH
  "filenames.backslash yes",
#else
  "filenames.backslash no",
#endif
#if DK_HAVE_FEATURE_ALLDOTALL
  "filenames.alldotall yes",
#else
  "filenames.alldotall no",
#endif
#if DK_HAVE_FEATURE_FN83
  "filenames.dos-style yes",
#else
  "filenames.dos-style no",
#endif
#if DK_HAVE_DOTFILENAMES
  "filenames.dotfiles yes",
#else
  "filenames.dotfiles no",
#endif
#if DK_WORDS_BIGENDIAN
  "bigendian yes",
#else
  "bigendian no",
#endif
  NULL
};



static char *keys_for_user[] = {
  "directory.home",		/*  0 */
  "directory.temp",		/*  1 */
  "user.name",			/*  2 */
  "user.uid",			/*  3 */
  "user.gid",			/*  4 */
  "user.gecos",			/*  5 */
  "HOME",			/*  6 */
  "LOGNAME",			/*  7 */
  "TEMP",			/*  8 */
  "TMPDIR",			/*  9 */
  "/tmp",			/* 10 */
  "directory.current",		/* 11 */
  "user.language",		/* 12 */
  NULL
};



static
void
print_home_directory DK_P0() {
  size_t mpl;
  char *mybuffer;
  long l;
  mpl = (size_t)dksf_get_maxpathlen();
  if(mpl < 512) mpl = 512; if(mpl > 4096) mpl = 4096;
  mybuffer = dk_new(char,mpl);
  if(mybuffer) {
    /*
      0 home
      2 user name
      3 UID
      4 GID
      5 gecos
    */
    if(dksf_get_uname(mybuffer, mpl)) {
      printf("%s %s\n", keys_for_user[2], mybuffer);
    }
    if(dksf_get_home(mybuffer, mpl)) {
      printf("%s %s\n", keys_for_user[0], mybuffer);
    }
    if(dksf_have_getuid()) {
      l = dksf_getuid();
      printf("%s %ld\n", keys_for_user[3], l);
    }
    if(dksf_have_getgid()) {
      l = dksf_getgid();
      printf("%s %ld\n", keys_for_user[4], l);
    }
    dk_delete(mybuffer);
  }
}


static
void
print_language DK_P0() {
  char buffer[256], *cptr;
  cptr = getenv("LANG");
  if(cptr) {
    if(strlen(cptr) < sizeof(buffer)) {
      strcpy(buffer,cptr);
      printf("%s %s\n", keys_for_user[12], cptr);
    }
  } else {	/* check registry if available */
#if DK_HAVE_WINREG_H
    HKEY intkey;
    LONG intres;
    DWORD intType;
    DWORD intlen;
    char intchar[64];
    char *intptr;
    char intc;
    intres = RegOpenKeyExA(
      HKEY_CURRENT_USER,
      "Control Panel\\International",
      (DWORD)0,
      KEY_READ,
      &intkey
    );
    if(intres == ERROR_SUCCESS) {
      intType = REG_SZ;
      intlen = (DWORD)sizeof(intchar);
      intres = RegQueryValueExA(
        intkey,
        "sLanguage",
        NULL,
        &intType,
        (LPBYTE)intchar,
        &intlen
      );
      if(intres == ERROR_SUCCESS) {
        if((intType == REG_SZ) || (intType == REG_EXPAND_SZ)) {
          if(intlen >= 2) {
            intchar[2] = '\0';
            strcpy(buffer, intchar);
            intptr = buffer;
            while(*intptr) {
              intc = *intptr;
      	      if(isascii(intc)) {
      	        if(isupper(intc)) {
      	          *intptr = tolower(intc);
      	        }
      	      }
              intptr++;
            }
            printf("%s %s\n", keys_for_user[12], buffer);
          }
        }
      }
      RegCloseKey(intkey);
    }
#endif
  }
}


static
void
print_temp_directory DK_P0() {
  size_t mpl;
  char *mybuffer;

  mpl = dksf_get_maxpathlen();
  if(mpl < 512) mpl = 512;
  if(mpl > 4096) mpl = 4096;
  mybuffer = dk_new(char,mpl);
  if(mybuffer) {
    if(dksf_get_tempdir(mybuffer, mpl)) {
      printf("%s %s\n", keys_for_user[1], mybuffer);
    }
    if(dksf_getcwd(mybuffer, mpl)) {
      printf("%s %s\n", keys_for_user[11], mybuffer);
    }
    dk_delete(mybuffer);
  }
}




static
void
platform_information DK_P0() {
  char **ptr;
  ptr = platform_strings;
  while(*ptr) { printf("%s\n", *(ptr++)); }
  print_temp_directory();
  print_home_directory();
  print_language();
}



#if DK_HAVE_PROTOTYPES
int main(int argc, char *argv[])
#else
int main(argc, argv); int argc; char *argv[];
#endif
{
  int cmd = 0;
  if(argc > 0) {
    cmd = dkstr_array_index(command_names, argv[1], 1);
    if(cmd < 0) cmd = 0;
  }
  switch(cmd) {
    case 0: { platform_information(); } break;
  }
  exit(0); return 0;
}


