/*
jlayout - A Java code generator for GUI layout
Copyright (c) 2007-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	jlclean.c	The jlclean module of the jlayout program.
*/



/**	Inside the jlclean module.
*/
#define JLCLEAN_C	1
#include	"jl.h"




#line 53 "jlclean.ctr"




/**	Cleanup after processing, release memory.
	@param	j	Jlayout job.
*/
void
jlcleanup DK_P1(JLJ *,j)
{
  JLO *o; JSG *g; char *x;
  
  if(j->uc_st) {
    if(j->uc_it) {
      
      dksto_it_reset(j->uc_it);
      while((x = (char *)dksto_it_next(j->uc_it)) != NULL) {
        
        dk_delete(x);
      }
      dksto_it_close(j->uc_it);
    }
    dksto_close(j->uc_st);
  } j->uc_st = NULL; j->uc_it = NULL;
  if(j->b_st) {
    if(j->b_it) {
      
      dksto_it_reset(j->b_it);
      while((g = (JSG *)dksto_it_next(j->b_it)) != NULL) {
        jsg_delete(g);
      }
      dksto_it_close(j->b_it);
    } j->b_it = NULL;
    dksto_close(j->b_st);
  } j->b_st = NULL;
  if(j->g_st) {
    if(j->g_it) {
      
      dksto_it_reset(j->g_it);
      while((g = (JSG *)dksto_it_next(j->g_it)) != NULL) {
        jsg_delete(g);
      }
      dksto_it_close(j->g_it);
    }
    dksto_close(j->g_st);
  } j->g_st = NULL; j->g_it = NULL;
  if(j->o_st) {
    if(j->o_it) {
      dksto_it_reset(j->o_it);
      while((o = (JLO *)dksto_it_next(j->o_it)) != NULL) {
        jlo_delete(o);
      }
      dksto_it_close(j->o_it);
    }
    dksto_close(j->o_st);
  } j->o_st = NULL; j->o_it = NULL;
  if(j->o_main) {
    jlo_delete(j->o_main);
  } j->o_main = NULL;
  if(j->def_border) {
    x = j->def_border; dk_delete(x);
  } j->def_border = NULL;
  
}



