/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	b2bj.c	Bmeps job functions.
*/



/**	Inside of b2bj.c
*/
#define B2BJ_C		1
#include "bmepsi.h"




#line 52 "b2bj.ctr"




/**	Intialize bmeps job.
	@param	bj	Bmeps job to initialize.
*/
void
bmeps_bj_init DK_P1(BJ *,bj)
{
  bj->bo = NULL;
  bj->bo2 = NULL;
  bj->outf = NULL;
  bj->infname = NULL;
  bj->frame_s = -1L;
  bj->frame_e = 0L;
  bj->frame_n = 0L;
  bj->a = NULL;
  bj->exval = 0;
  bj->cmd = 0;
  bj->it = DKBIF_TYPE_UNKNOWN;
  bj->i1 = NULL;
  bj->o1 = NULL;
  bj->lang = NULL;
  bj->msg = NULL;
  bj->me = 0;
  bj->bif = NULL;
  bj->mm = 0x00;
  bj->frame_c = 0x00;
  bj->pdfobjs = NULL;
  bj->pdfobjsi = NULL;
  bj->psp = 0UL;
  bj->olo = 0UL;
  bj->af = 0x00;
  bj->alpha_channel_transferred = 0x00;
  bj->suppress_alpha_info = 0x00;
}


