/*
Copyright (c) 2001-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	snmpyalc.c	The snmpyalc program.
*/



#include <stdio.h>

#include <dk.h>
#if DK_HAVE_STDLIB_H
#include <stdlib.h>
#endif
#if DK_HAVE_STRING_H
#include <string.h>
#endif
#if DK_HAVE_UNISTD_H
#include <unistd.h>
#endif
#if DK_HAVE_PROCESS_H
#include <process.h>
#endif

#include <dkapp.h>
#include <dktcpip.h>
#include <dklic.h>
#include <yalc.h>


#line 66 "snmpyalc.ctr"




/**	Exit status.
*/
static int exval = 0;



/**	Flag: Always return exit status 0.
*/
static int ignore_exval = 0;



/**	Flag: Run silently.
*/
static int run_silently = 0;



/**	System configuration directory.
*/
static char sysconfdir[] = { DK_SYSCONFDIR };



/**	Program group name.
*/
static char prg_group_name[] = { "dktools" };



/**	Application.
*/
static dk_app_t *app = NULL;



/**	Default help text, printed if help text file is not found.
*/
static char *snmp_yalc_help[] = {
  "",
  "snmpyalc [ -P <print-queue> ] [ -H <snmp-host> ] [ -C <snmp-community> ]",
  "         [ -V <version>] [ -T <type> ] [-i] [-s] [-f]",
  "",
  "     print-queue:    print queue to check, i.e. \"lp@server\"",
  "     snmp-host:      SNMP host, DNS name or IP address",
  "     snmp-community: SNMP community, i.e. \"public\"",
  "     version:        SNMP protocol version (1, 2, 2c, 2p, 3)",
  "     -i              always return exit()-value 0",
  "     -s              run silently (no errors, warnings...)",
  "     -f              force output",
  "",
  NULL
};



/**	Long options.
*/
static char *long_options[] = {
  /*  0 */ "p$rinter",
  /*  1 */ "s$erver",
  /*  2 */ "c$ommunity",
  /*  3 */ "pro$tocol",
  /*  4 */ "i$gnore-exit-code",
  /*  5 */ "f$orce",
  /*  6 */ "si$lently",
  /*  7 */ "v$ersion",
  /*  8 */ "h$elp",
  NULL
};



/**	Run normally or print help/version text.
	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
	@return	1 on success, 0 on error.
*/
static int
run DK_P2(int,argc,char **,argv)
{
  int back = 0;
  int version_wanted, help_wanted, force_output, longno;
  char *device_name;
  char *snmp_host;
  char *snmp_comm;
  char *snmp_vers;
  char *snmp_type;
  char *valptr;

  int xargc;
  char *pchar, **xargv;
  yalc_rq_t *rq;

  
  /*
  	Setup
  */
  device_name = snmp_host = snmp_comm = snmp_vers = snmp_type = NULL;
  /*
  	Check arguments
  */
  xargc = 0; xargv = argv;
  xargc++; xargv++;
  version_wanted = help_wanted = force_output = 0;
  while(xargc < argc) {
    pchar = *xargv;
    if(*pchar == '-') {
      pchar++;
      switch(*pchar) {
        case '-' : {
	  /* long option */
	  pchar++;
	  valptr = dkstr_chr(pchar, '=');
	  if(valptr) { *(valptr++) = (char)0; }
          longno = dkstr_array_abbr(long_options, pchar, '$', 0);
	  switch(longno) {
	    case 0: {
	      if(valptr) {
	      if(!device_name) {
	        device_name = valptr;
	      }
	      }
	    } break;
	    case 1: {
	      if(valptr) {
	      if(!snmp_host) {
	        snmp_host = valptr;
	      }
	      }
	    } break;
	    case 2: {
	      if(valptr) {
	      if(!snmp_comm) {
	        snmp_comm = valptr;
	      }
	      }
	    } break;
	    case 3: {
	      if(valptr) {
	      if(!snmp_vers) {
	        snmp_vers = valptr;
	      }
	      }
	    } break;
	    case 4: {
	      if(valptr) {
	        if(dkstr_is_on(valptr)) {
		  ignore_exval = 1;
		} else {
		  ignore_exval = 0;
		}
	      } else {
	        ignore_exval = 1;
	      }
	    } break;
	    case 5: {
	      if(valptr) {
	        if(dkstr_is_on(valptr)) {
		  force_output = 1;
		} else {
		  force_output = 0;
		}
	      } else {
	        force_output = 1;
	      }
	    } break;
	    case 6: {
	      if(valptr) {
	        if(dkstr_is_on(valptr)) {
		  run_silently = 1;
		} else {
		  run_silently = 0;
		}
	      } else {
	        run_silently = 1;
	      }
	    } break;
	    case 7: {
	      if(valptr) {
	        if(dkstr_is_on(valptr)) {
		  version_wanted = 1;
		} else {
		  version_wanted = 0;
		}
	      } else {
	        version_wanted = 1;
	      }
	    } break;
	    case 8: {
	      if(valptr) {
	        if(dkstr_is_on(valptr)) {
		  help_wanted = 1;
		} else {
		  help_wanted = 0;
		}
	      } else {
	        help_wanted = 1;
	      }
	    } break;
	  }
	} break;
        case 'P' : {
	  pchar++;
	  if(!(*pchar)) {
	    pchar = NULL;
	    xargc++; xargv++;
	    if(xargc < argc) {
	      pchar = *xargv;
	    }
	  }
	  if(pchar) {
	  if(*pchar) {
	    if(!device_name) {
	      device_name = pchar;
	    }
	  }
	  }
	} break;
	case 'f' : {
	  force_output = 1;
	} break;
	case 'i' : {
	  ignore_exval = 1;
	} break;
	case 'H' :
	case 'S' : {
	  pchar++;
	  if(!(*pchar)) {
	    pchar = NULL;
	    xargc++; xargv++;
	    if(xargc < argc) {
	      pchar = *xargv;
	    }
	  }
	  if(pchar) {
	  if(*pchar) {
	    if(!snmp_host) {
	      snmp_host = pchar;
	    }
	  }
	  }
	} break;
	case 'C' : {
	  pchar++;
	  if(!(*pchar)) {
	    pchar = NULL;
	    xargc++; xargv++;
	    if(xargc < argc) {
	      pchar = *xargv;
	    }
	  }
	  if(pchar) {
	  if(*pchar) {
	    if(!snmp_comm) {
	      snmp_comm = pchar;
	    }
	  }
	  }
	} break;
	case 'V' : {
	  pchar++;
	  if(!(*pchar)) {
	    pchar = NULL;
	    xargc++; xargv++;
	    if(xargc < argc) {
	      pchar = *xargv;
	    }
	  }
	  if(pchar) {
	  if(*pchar) {
	    if(!snmp_vers) {
	      snmp_vers = pchar;
	    }
	  }
	  }
	} break;
	case 'T' : {
	  pchar++;
	  if(!(*pchar)) {
	    pchar = NULL;
	    xargc++; xargv++;
	    if(xargc < argc) {
	      pchar = *xargv;
	    }
	  }
	  if(pchar) {
	  if(*pchar) {
	    if(!snmp_type) {
	      snmp_type = pchar;
	    }
	  }
	  }
	} break;
	case 'v': version_wanted = 1; break;
	case 'h': help_wanted = 1; break;
	case 's': break;
	default: {
	  help_wanted = 1;
	} break;
      }
    } else {
      help_wanted = 1;
    }
    xargc++; xargv++;
  }
  /*
  	Argument checking done.
  */
  if(version_wanted || help_wanted || (!((snmp_host) || (device_name)))) {
    /*
    	Show version and/or help
    */
    /* print version */
    if(version_wanted) {
          char **licptr;
	  printf("\n");
	  {
	    char **vptr;
	    vptr = yalc_get_version();
	    if(vptr) {
	      while(*vptr) {
	        printf("%s\n", *(vptr++));
	      }
	    }
	  }
	  printf("\nLibraries used:\n\n");
	  licptr = dklic_get();
	  while(*licptr) {
	    printf("%s\n", *(licptr++));
	  }
	  printf("\n");
    }
    /* print help if wanted */
    if(help_wanted) {
      dkapp_help(app, "snmpyalc.txt", snmp_yalc_help);
    }
  } else {
    /*
    	Really run
    */
    
    rq = yalc_new();
    if(rq) {
      yalc_set_snmp_status(rq);
      if(device_name) {
        yalc_set_printer(rq, device_name);
      } else {
        if(snmp_host) {
	  yalc_set_snmp_host(rq, snmp_host);
	}
	if(snmp_comm) {
	  yalc_set_snmp_comm(rq, snmp_comm);
	}
	if(snmp_vers) {
	  yalc_set_snmp_vers(rq, snmp_vers);
	}
	if(snmp_type) {
	  yalc_set_snmp_type(rq, snmp_type);
	}
      }
      yalc_set_app(rq,app);
      if(force_output) {
        yalc_set_snmp_force(rq, force_output);
      }
      exval = yalc_run(rq);
      yalc_delete(rq);
    }
  }
  
  return back;
}



/**	Check whether to run silently.
	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
*/
static void
silence_check DK_P2(int,argc,char **,argv)
{
  int i; char *cptr; char *valptr;
  for(i = 1; i < argc; i++) {
    if(strcmp("-s", argv[i]) == 0) {
      run_silently = 1;
    } else {
      cptr = argv[i];
      if((cptr[0] == '-') && (cptr[1] == '-')) {
        cptr = &(cptr[2]);
	valptr = dkstr_chr(cptr, '=');
	if(valptr) {
	  *valptr = (char)0;
          if(dkstr_is_abbr(cptr, long_options[6], '$', 0)) {
	    run_silently = (dkstr_is_on(&(valptr[1])) ? 1 : 0);
	  }
	  *valptr = '=';
	} else {
	  if(dkstr_is_abbr(cptr, long_options[6], '$', 0)) {
	    run_silently = 1;
	  }
	}
      }
    }
  }
}



/**	The main() function of the snmpyalc program.
	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
	@return	0 on success, any other value indicates an error.
*/
#if DK_HAVE_PROTOTYPES
int main(int argc, char *argv[])
#else
int main(argc,argv) int argc; char *argv[];
#endif
{
  int xargc; char **xargv;
  
#line 491 "snmpyalc.ctr"

  silence_check(argc, argv);
  if(!run_silently) {
    run_silently = dkapp_silence_check(argc,argv);
  }
  app = dkapp_open_ext1(argc,argv,prg_group_name,sysconfdir,run_silently,0);
  if(app) {
    if(dktcpip_start()) {
      xargc = dkapp_get_argc(app);
      xargv = dkapp_get_argv(app);
      exval = run(xargc,xargv);
      dktcpip_end();
    } else {
      dkapp_err_tcpip(app);
    }
    dkapp_close(app); app = NULL;
  } else {
    fprintf(stderr, "Not enough memory!\n");
    fflush(stderr);
  }
  exval = (exval ? 0 : 1);
  if(ignore_exval) { exval = 0; }
  
#line 513 "snmpyalc.ctr"

  exit(exval); return exval;
}


