/*
Copyright (c) 1998-2005, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  its contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



#include <stdio.h>

#if DK_TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#if DK_HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#if DK_HAVE_TIME_H
#include <time.h>
#endif
#endif
#endif

#define DK_TRACE_C 1
#include "dktrace.h"

static FILE *trace_file = NULL;

void  dktrace_end(void)
{
  if(trace_file) {
    fclose(trace_file); trace_file = NULL;
  }
}

void dk_trace_end(void) { dktrace_end(); }

void  dktrace_init(char *filename)
{
  FILE *x;
  if(filename) {
    x = fopen(filename, "w");
    if(x) {
      dktrace_end();
      trace_file = x;
    }
  }
}

void dk_trace_init(char *filename) { dktrace_init(filename); }


FILE *dktrace_file(void)
{
  return trace_file;
}

FILE *dk_trace_file(void) { FILE *back; back = dktrace_file(); return back; }

static
void i_time(FILE *f)
{
#if DK_HAVE_TIME_H || DK_HAVE_SYS_TIME_H
  time_t timer;
  struct tm *tm;
  if(f) {
    time(&timer);
    tm = localtime(&timer);
    if(tm) {
      fprintf(f,
	  "%04d/%02d/%02d %02d:%02d:%02d\n",
	  (1900 + tm->tm_year),
	  (1 + tm->tm_mon),
	  tm->tm_mday,
	  tm->tm_hour,
	  tm->tm_min,
	  tm->tm_sec
      );
    }
  }
#endif
}

void dktrace_time(void)
{
  if(trace_file) {
    i_time(trace_file);
  }
}

void dktrace_stdout_time(void)
{
  i_time(stdout);
}

void dk_trace_time(void)
{
  dktrace_time();
}



#ifndef LINT
static char sccs_id[] = {
"@(#) 1.13 dktrace.ctr 07/18/06\t(krause) - Trace module"
};
#endif

