
package haconfig;

sub read_credentials($$)
{
  my $self = shift;
  my $fn = shift;
  my $line;
  my $foundusername = 0;
  my $foundpassword = 0;
  my $scope;
  my $v;
  if(open(ICRF, "<$fn")) {
    $scope = 0;
    while(<ICRF>) {
      $line = $_; chomp $line;
      if($line =~ /^\s*\[/o) {
        $scope = 0;
	if($line =~ /^\s*\[\s*mysql\s*\]\s*$/o) {
	  $scope = 2;
	} else {
	  if($line =~ /^\s*\[\s*client\s*\]\s*$/o) {
	    $scope = 1;
	  }
	}
      } else {
        if($scope > 0) {
	  if($line =~ /^\s*user\s*=\s*(\S+)\s*$/o) {
	    $v = $1;
	    if($scope >= $foundusername) {
	      $self->{'dbuser'} = $v;
	      $foundusername = $scope;
	    }
	  } else {
	    if($line =~ /^\s*password\s*=\s*(\S+)\s*$/o) {
	      $v = $1;
	      if($scope >= $foundpassword) {
	        $self->{'dbpass'} = $v;
		$foundpassword = $scope;
	      }
	    }
	  }
	}
      }
    }
    close(ICRF);
  } else {
    print "hostsadm: ERROR: Failed to open credentials file \"$fn\"!\n";
  }
}

sub set_debug($$)
{
  my $self = shift;
  my $l = shift;
  if($l =~ /^\s*none\s*$/o) {
    $self->{'debug'} = 0;
  } else {
    if($l =~ /^\s*err(or?)?\s*$/o) {
      $self->{'debug'} = 1;
    } else {
      if($l =~ /^\s*warn(i(ng)?)?\s*$/o) {
        $self->{'debug'} = 2;
      } else {
        if($l =~ /^\s*info(r(m(a(t(i(on?)?)?)?)?)?)?\s*$/o) {
	  $self->{'debug'} = 3;
	} else {
	  if($l =~ /^\s*pro(g(r(e(ss?)?)?)?)?\s*$/o) {
	    $self->{'debug'} = 4;
	  } else {
	    if($l =~ /^\s*deb(ug?)?\s*$/o) {
	      $self->{'debug'} = 5;
	    } else {
	      $self->{'debug'} = 0;
	    }
	  }
	}
      }
    }
  }
}

sub check_bool($)
{
  my $arg = shift;
  my $back = 0;
  my $v;
  if("$arg" =~ /^\s*(\d+)/o) {
    $v = $1;
    $back = 0 + $v;
  } else {
    if("$arg" eq "y")    { $back = 1; }
    if("$arg" eq "yes")  { $back = 1; }
    if("$arg" eq "true") { $back = 1; }
    if("$arg" eq "ok")   { $back = 1; }
    if("$arg" eq "on")   { $back = 1; }
  }
  return $back;
}

sub read_configuration_file($$)
{
  my $self = shift;
  my $fn = shift;
  my $line;
  my $scope = 0;
  if(defined($fn)) {
    if(open(INPUT, "<$fn")) {
      while(<INPUT>) {
        $line = $_; chomp $line;
	if($line =~ /^\s*\[/o) {
	  $scope = 0;
	  if($line =~ /^\s*\[\s*database\s*\]\s*$/o) {
	    $scope = 1;
	  } else {
	    if($line =~ /^\s*\[\s*options\s*\]\s*$/o) {
	      $scope = 2;
	    } else {
	      # probably we will need other scopes later
	    }
	  }
	} else {
	  if(($scope == 0) || ($scope == 1)) {
	    if($line =~ /^\s*host\s*=\s*(\S+)\s*$/o) {
	      $self->{'dbhost'} = $1;
	    } else {
	      if($line =~ /^\s*name\s*=\s*(\S+)\s*$/o) {
	        $self->{'dbname'} = $1;
	      } else {
	        if($line =~ /^\s*credentials\s+file\s*=\s*(\S+)\s*$/o) {
	          $self->read_credentials($1);
	        } else {
		  # the place for other database related options
		}
	      }
	    }
	  } else {
	    if($scope == 2) {
	      if($line =~ /^\s*debug\s+level\s*=\s*(\S+)\s*$/o) {
	          $self->set_debug($1);
	      } else {
	        if($line =~ /^\s*output\s+directory\s*=\s*(\S+)\s*$/o) {
	          $self->{'outdir'} = $1;
	        } else {
		  if($line =~ /^\s*comments\s+in\s+hosts\s*=\s*(\S+)/o) {
		    $self->{'cohosts'} = check_bool($1);
		  } else {
		    if($line =~ /^\s*comments\s+in\s+ethers\s*=\s*(\S+)/o) {
		      $self->{'coethers'} = check_bool($1);
		    } else {
		      if($line =~ /^\s*ldap\s+base\s*=\s*(\S+)\s*$/o) {
		        $self->{'ldapbase'} = $1;
		      } else {
			if($line =~ /^\s*comments\s+in\s+dhcpd\s*=\s*(\S+)/o) {
			  $self->{'codhcpd'} = check_bool($1);
			} else {
			  if($line =~ /^\s*decode\s+utf\-8\s+strings\s*=\s*(\S+)/o) {
			    $self->{'decutf-8'} = check_bool($1);
			  } else {
			    if($line =~ /^\s*documentation\s+language\s*=\s*(\S+)/o) {
			      $self->{'doclang'} = "$1";
			    } else {
			      # inspect input lines for other options in scope 2
			    }
			  }
			}
		      }
		    }
		  }
	        }
	      }
	    } else {
	      # inspect input lines for other scopes
	    }
	  }
	}
      }
      close(INPUT);
    } else {
      print "hostsadm: ERROR: Failed to open configuration file \"$fn\"!\n";
    }
  } 
}

sub new
{
  my $class = shift;
  my $filename = shift;
  my $self = {
    'dbhost'	=> undef,
    'dbname'	=> undef,
    'dbuser'	=> undef,
    'dbpass'	=> undef,
    'debug'	=> undef,
    'outdir'	=> '.',
    'cohosts'	=> 0,
    'coethers'	=> 0,
    'codhcpd'	=> 0,
    'decutf-8'	=> 0,
    'doclang'	=> 'en',
    'ldapbase'	=> 'dc=my-corporation,dc=com'
  };
  bless($self,$class);
  $self->read_configuration_file($filename);
  return $self;
}

1;

