/*
Copyright (c) 1998-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

/**	@file dktrace.h Functions and macros for tracing.
*/

#ifndef DK_TRACE_INC
#define DK_TRACE_INC 1

#ifndef DK_INC
#include <dkconfig.h>
#include <dkproto.h>
#endif
/* ifndef DK_INC */

#if defined(EXTERN)
#undef EXTERN
#endif
#ifndef DK_TRACE_C
#if !DK_HAVE_PROTOTYPES
#define EXTERN extern
#else
#define EXTERN /* nix */
#endif
#else
#define EXTERN /* nix */
#endif
#include <stdio.h>

#if defined(__cplusplus)
extern "C" {
#endif



/**	Close trace output file.
*/
EXTERN void  dktrace_end    DK_PR((void)) ;



/**	Start tracing.
	@param	n	File name to write trace output
	or NULL to use standard output.
*/
EXTERN void  dktrace_init   DK_PR((char *n)) ;



/**	Get trace file.
	@return	Pointer to open file used for tracing.
*/
EXTERN FILE *dktrace_file   DK_PR((void)) ;



/**	Close trace output file.
*/
EXTERN void  dk_trace_end    DK_PR((void)) ;



/**	Start tracing.
	@param	n	File name to write trace output
	or NULL to use standard output.
*/
EXTERN void  dk_trace_init   DK_PR((char *n)) ;



/**	Get trace file.
	@return	Pointer to open file used for tracing.
*/
EXTERN FILE *dk_trace_file   DK_PR((void)) ;



/**	Write time to trace output.
*/
EXTERN void  dktrace_time    DK_PR((void));



/**	Write time to trace output.
*/
EXTERN void  dk_trace_time   DK_PR((void));



/**	Write time to standard output.
*/
EXTERN void  dktrace_stdout_time DK_PR((void));



#if defined(__cplusplus)
}
#endif
/* ifdef __cplusplus */


/** Show string. */
#define TR_STR(x)	((x) ? (x) : "(NULL)")


/** Show pointer. */
#define TR_PTR(x)	((x) ? "PTR" : "(NULL)")



#endif
/* ifndef DK_TRACE_INC */

