<CsoundSynthesizer>
<CsOptions>
; Select audio/midi flags here according to platform
; Audio out   Audio in    No messages
-odac           -iadc     -d     ;;;RT audio I/O
; For Non-realtime ouput leave only the line below:
; -o rspline.wav -W ;;; for file output any platform
</CsOptions>
<CsInstruments>

; Initialize the global variables.
sr = 44100
kr = 4410
ksmps = 10
nchnls = 2

; Instrument #1 -- plain instrument.
instr 1
  aplain vco 10000, 220, 2, 0.83

  outs aplain, aplain
endin

; Instrument #2 
instr 2
  ; Create a signal modulated the rspline opcode.
  kamp init 2
  kcpsmin init 4
  kcpsmax init 10
  kj rspline -20,20, kcpsmin, kcpsmax

  aplain vco 10000, 220, 2, 0.83
  ajitter vco 10000, 220+kj, 2, 0.83

  outs aplain, ajitter
endin


</CsInstruments>
<CsScore>

; Table #1, a sine wave.
f 1 0 16384 10 1

; Play Instrument #1 for 3 seconds.
i 1 0 3
; Play Instrument #2 for 3 seconds.
i 2 3 5
e


</CsScore>
</CsoundSynthesizer>
