/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.test.CipherTest;
import cryptix.jce.test.Util;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;

final class TestTripleDESInnerCBC
extends CipherTest {
    private static final String NAME = "TripleDESInnerCBC/InnerCBC/None";
    private String[][] VECS = new String[][]{{"000000000000000000000000000000000000000000000000", "000000000000000000000000000000000000000000000000", "31366279746573617265656E6F756768", "844758AE22ADF08AC357F0587188242D"}};

    protected TestTripleDESInnerCBC() {
        super(NAME);
    }

    protected void doIt() throws Exception {
        this.testExistence(NAME);
        this.testValuesCFB(NAME, this.VECS);
    }

    protected void testValuesCFB(String alg, String[][] testValues) throws Exception {
        this.beginTest("XXX...");
        boolean res = true;
        try {
            int i = 0;
            while (i < testValues.length) {
                byte[] key = Util.hexFromString(testValues[i][0]);
                byte[] iv = Util.hexFromString(testValues[i][1]);
                byte[] pt = Util.hexFromString(testValues[i][2]);
                byte[] ct = Util.hexFromString(testValues[i][3]);
                IvParameterSpec ivs = new IvParameterSpec(iv);
                Cipher c = Cipher.getInstance(NAME, "CryptixCrypto");
                c.init(1, (Key)new K(NAME, key), ivs);
                byte[] trial_ct = c.doFinal(pt);
                c.init(2, (Key)new K(NAME, key), ivs);
                byte[] trial_pt = c.doFinal(ct);
                if (!Util.areEqual(ct, trial_ct) || !Util.areEqual(pt, trial_pt)) {
                    res = false;
                }
                ++i;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            res = false;
        }
        this.passIf(res);
    }

    private class K
    implements Key {
        private final byte[] keyBytes;
        private final String alg;

        K(String alg, byte[] keyBytes) {
            this.alg = alg;
            this.keyBytes = keyBytes;
        }

        public String getAlgorithm() {
            return this.alg;
        }

        public byte[] getEncoded() {
            return (byte[])this.keyBytes.clone();
        }

        public String getFormat() {
            return "RAW";
        }
    }
}

