/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.test.Test;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.Signature;
import javax.crypto.Cipher;

class TestRSA
extends Test {
    private static SecureRandom random = new SecureRandom();

    TestRSA() {
        super("RSA");
    }

    protected void doIt() {
        int PASSES = 50;
        int i = 0;
        while (i < PASSES) {
            long start = System.currentTimeMillis();
            String pass = "(pass " + i + "/" + PASSES + ")";
            this.doItPrivate2(pass);
            this.doItPrivate1(pass);
            long delta = (System.currentTimeMillis() - start) / 1000L;
            ++i;
        }
    }

    private void doItPrivate1(String pass) {
        this.beginTest("RSA Signing " + pass);
        boolean res = false;
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
            gen.initialize(768);
            KeyPair pair = ((KeyPairGeneratorSpi)gen).generateKeyPair();
            Signature sig = Signature.getInstance("SHA1withRSA");
            sig.initSign(pair.getPrivate());
            sig.update((byte)0);
            byte[] signed = sig.sign();
            sig.initVerify(pair.getPublic());
            sig.update((byte)0);
            signed[0] = ~signed[0];
            res = true;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.passIf(res);
    }

    private void doItPrivate2(String pass) {
        this.beginTest("RSA Crypting " + pass);
        boolean res = false;
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
            gen.initialize(768);
            KeyPair pair = ((KeyPairGeneratorSpi)gen).generateKeyPair();
            Cipher c = Cipher.getInstance("RSA/ECB/PKCS#1");
            res = true;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.passIf(res);
    }
}

