/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Properties;

public class AlgorithmParameters {
    private AlgorithmParametersSpi paramSpi = null;
    private Provider provider = null;
    private String algorithm = null;
    private boolean isInitialized = false;

    protected AlgorithmParameters(AlgorithmParametersSpi paramSpi, Provider provider, String algorithm) {
        this.paramSpi = paramSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final byte[] getEncoded() throws IOException {
        if (!this.isInitialized) {
            throw new IOException();
        }
        return this.paramSpi.engineGetEncoded();
    }

    public final byte[] getEncoded(String format) throws IOException {
        if (!this.isInitialized) {
            throw new IOException();
        }
        return this.paramSpi.engineGetEncoded(format);
    }

    public static AlgorithmParameters getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] allInstalledProviders = Security.getProviders();
        int i = 0;
        if (i < allInstalledProviders.length) {
            try {
                AlgorithmParameters ap = AlgorithmParameters.getInstance(algorithm, allInstalledProviders[i].getName());
                return ap;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new NoSuchAlgorithmException();
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new NoSuchAlgorithmException();
            }
        }
        throw new NoSuchAlgorithmException();
    }

    public static AlgorithmParameters getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        AlgorithmParametersSpi algorithmSpi = null;
        if (provider == null || provider.length() == 0) {
            return AlgorithmParameters.getInstance(algorithm);
        }
        Provider tempProv = Security.getProvider(provider);
        if (tempProv == null) {
            throw new NoSuchProviderException();
        }
        String key = "AlgorithmParameters." + algorithm;
        String prop = ((Properties)tempProv).getProperty(key);
        if (prop == null) {
            throw new NoSuchAlgorithmException();
        }
        try {
            algorithmSpi = (AlgorithmParametersSpi)Class.forName(prop).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            throw new NoSuchAlgorithmException();
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        return new AlgorithmParameters(algorithmSpi, tempProv, algorithm);
    }

    public final AlgorithmParameterSpec getParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        return this.paramSpi.engineGetParameterSpec(paramSpec);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        this.paramSpi.engineInit(paramSpec);
        this.isInitialized = true;
    }

    public final void init(byte[] params) throws IOException {
        this.paramSpi.engineInit(params);
        this.isInitialized = true;
    }

    public final void init(byte[] params, String format) throws IOException {
        this.paramSpi.engineInit(params, format);
        this.isInitialized = true;
    }

    public final String toString() {
        if (!this.isInitialized) {
            return null;
        }
        return this.paramSpi.engineToString();
    }
}

