/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.rsa;

import cryptix.jce.util.MPIOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;

public final class RSAPrivateKeyCryptix
implements RSAPrivateKey {
    private final BigInteger n;
    private final BigInteger d;

    public RSAPrivateKeyCryptix(BigInteger n, BigInteger d) {
        this.n = n;
        this.d = d;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MPIOutputStream mos = new MPIOutputStream((OutputStream)baos);
            mos.write(this.n);
            mos.write(this.d);
            mos.flush();
            mos.close();
            return baos.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("PANIC");
        }
    }

    public String getFormat() {
        return "Cryptix";
    }

    public BigInteger getModulus() {
        return this.n;
    }

    public BigInteger getPrivateExponent() {
        return this.d;
    }
}

