/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.rsa;

import cryptix.jce.provider.rsa.RSAAlgorithm;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public final class RSACipher_ECB_PKCS1
extends CipherSpi {
    private BigInteger n;
    private BigInteger e;
    private BigInteger p;
    private BigInteger q;
    private BigInteger u;
    private boolean decrypt;

    protected final byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        int ret;
        byte[] o = new byte[this.engineGetOutputSize(inputLen)];
        try {
            ret = this.engineDoFinal(input, inputOffset, inputLen, o, 0);
            if (ret == o.length) {
                return o;
            }
        }
        catch (ShortBufferException shortBufferException) {
            throw new RuntimeException("PANIC: Should not happned!");
        }
        byte[] r = new byte[ret];
        System.arraycopy(o, 0, r, 0, ret);
        return r;
    }

    protected final int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (output.length < this.engineGetOutputSize(inputLen)) {
            throw new ShortBufferException("Output buffer too small!");
        }
        byte[] blub = new byte[inputLen];
        System.arraycopy(input, inputOffset, blub, 0, inputLen);
        if (this.decrypt) {
            BigInteger bi = new BigInteger(1, blub);
            if (bi.compareTo(this.n) != -1) {
                throw new RuntimeException("TT");
            }
            BigInteger res = RSAAlgorithm.rsa(bi, this.n, this.e, this.p, this.q, this.u);
            byte[] b = res.toByteArray();
            return this.unpad(b, b.length, 0, output, outputOffset);
        }
        BigInteger bi = new BigInteger(1, this.pad(blub, blub.length, 0, 2));
        if (bi.compareTo(this.n) != -1) {
            throw new RuntimeException("TT");
        }
        BigInteger res = RSAAlgorithm.rsa(bi, this.n, this.e);
        if (res.compareTo(this.n) != -1) {
            throw new RuntimeException("TT");
        }
        int blockSize = this.engineGetBlockSize();
        byte[] b = res.toByteArray();
        if (b.length - 1 > blockSize) {
            throw new RuntimeException("YY");
        }
        if (b.length > blockSize) {
            byte[] t = new byte[blockSize];
            System.arraycopy(b, 1, t, 0, blockSize);
            b = t;
        }
        int i = 0;
        while (i < blockSize) {
            output[outputOffset + i] = 0;
            ++i;
        }
        int bOff = blockSize - b.length;
        System.arraycopy(b, 0, output, outputOffset + bOff, b.length);
        return b.length + bOff;
    }

    protected final int engineGetBlockSize() {
        return (this.n.bitLength() + 7) / 8;
    }

    protected final byte[] engineGetIV() {
        return null;
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof RSAPublicKey) {
            return ((RSAPublicKey)key).getModulus().bitLength();
        }
        if (key instanceof RSAPrivateKey) {
            return ((RSAPrivateKey)key).getModulus().bitLength();
        }
        throw new InvalidKeyException("Not an RSA key.");
    }

    protected final int engineGetOutputSize(int inputLen) {
        return inputLen < this.engineGetBlockSize() + 1 ? this.engineGetBlockSize() + 1 : inputLen;
    }

    protected final AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected final void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("This cipher do not support AlgorithmParameters");
    }

    protected final void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        if (!(key instanceof RSAPrivateKey) && !(key instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Key must be instance of either RSAPublicKey or RSAPrivateKey!");
        }
        boolean bl = this.decrypt = opmode == 2 || opmode == 6;
        if (this.decrypt) {
            this.n = ((RSAPrivateKey)key).getModulus();
            this.e = ((RSAPrivateKey)key).getPrivateExponent();
        } else {
            this.n = ((RSAPublicKey)key).getModulus();
            this.e = ((RSAPublicKey)key).getPublicExponent();
        }
        if (key instanceof RSAPrivateCrtKey) {
            this.p = ((RSAPrivateCrtKey)key).getPrimeP();
            this.q = ((RSAPrivateCrtKey)key).getPrimeQ();
            this.u = ((RSAPrivateCrtKey)key).getCrtCoefficient();
        } else {
            this.u = null;
            this.q = null;
            this.p = null;
        }
    }

    protected final void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("This cipher do not support AlgorithmParameterSpecs");
    }

    protected final void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!mode.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException("Wrong mode type!");
        }
    }

    protected final void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (!(padding.equalsIgnoreCase("PKCS1") || padding.equalsIgnoreCase("PKCS#1") || padding.equalsIgnoreCase("PKCS1Padding"))) {
            throw new NoSuchPaddingException("Wrong padding scheme!");
        }
    }

    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        if (wrappedKeyType != 5) {
            throw new InvalidKeyException("Wrong keytype!");
        }
        try {
            KeyGenerator.getInstance(wrappedKeyAlgorithm, "Cryptix");
            byte[] buf = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
            SecretKeySpec sks = new SecretKeySpec(buf, 0, buf.length, wrappedKeyAlgorithm);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(wrappedKeyAlgorithm);
            return skf.generateSecret(sks);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("Algorithm not supported!");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException("PANIC: Should not happend!");
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException("PANIC: This should not happend!");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new RuntimeException("PANIC: This should not happend!");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new RuntimeException("PANIC: This should not happend!");
        }
    }

    protected final byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        throw new RuntimeException("You can't do an update when using PKCS1!");
    }

    protected final int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        throw new RuntimeException("You can't do an update when using PKCS1!");
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        String format = key.getFormat();
        if (format == null || !format.equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("Wrong format on key!");
        }
        byte[] buf = key.getEncoded();
        try {
            return this.engineDoFinal(buf, 0, buf.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException("PANIC: This should not happend!");
        }
    }

    private byte[] pad(byte[] input, int inputLen, int offset, int bt) throws BadPaddingException {
        int k = (this.n.bitLength() + 7) / 8;
        if (inputLen > k - 11) {
            throw new BadPaddingException("Data too long for this modulus!");
        }
        byte[] ed = new byte[k];
        int padLen = k - 3 - inputLen;
        ed[2 + padLen] = 0;
        ed[0] = 0;
        switch (bt) {
            case 0: {
                int i = 1;
                while (i < 2 + padLen) {
                    ed[i] = 0;
                    ++i;
                }
                break;
            }
            case 1: {
                ed[1] = 1;
                int i = 2;
                while (i < 2 + padLen) {
                    ed[i] = -1;
                    ++i;
                }
                break;
            }
            case 2: {
                ed[1] = 2;
                byte[] b = new byte[1];
                SecureRandom sr = new SecureRandom();
                int i = 2;
                while (i < 2 + padLen) {
                    b[0] = 0;
                    while (b[0] == 0) {
                        sr.nextBytes(b);
                    }
                    ed[i] = b[0];
                    ++i;
                }
                break;
            }
            default: {
                throw new BadPaddingException("Wrong block type!");
            }
        }
        System.arraycopy(input, offset, ed, padLen + 3, inputLen);
        return ed;
    }

    private int unpad(byte[] input, int inputLen, int inOffset, byte[] output, int outOffset) throws BadPaddingException {
        byte bt = input[inOffset];
        int padLen = 1;
        switch (bt) {
            case 0: {
                while (input[inOffset + padLen + 1] == 0) {
                    ++padLen;
                }
                break;
            }
            case 1: 
            case 2: {
                while (input[inOffset + padLen] != 0) {
                    ++padLen;
                }
                break;
            }
            default: {
                throw new BadPaddingException("Wrong block type!");
            }
        }
        int len = inputLen - inOffset - ++padLen;
        System.arraycopy(input, inOffset + padLen, output, outOffset, len);
        return len;
    }
}

