/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.examples;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;

public final class MACs {
    private Mac mac = null;
    private Key key = null;

    public boolean run(String algorithm, String provider, String filename) {
        try {
            KeyGenerator kg = KeyGenerator.getInstance("HMAC", provider);
            kg.init(new SecureRandom());
            this.key = kg.generateKey();
            this.mac = Mac.getInstance(algorithm, provider);
            this.mac.init(this.key);
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
            return false;
        }
        catch (NoSuchProviderException nspe) {
            nspe.printStackTrace();
            return false;
        }
        catch (InvalidKeyException ike) {
            ike.printStackTrace();
            return false;
        }
        try {
            FileInputStream fInput = new FileInputStream(filename);
            FileOutputStream fOutput = new FileOutputStream(String.valueOf(filename) + "." + algorithm);
            byte[] buffer = new byte[8192];
            int length = 0;
            while ((length = fInput.read(buffer)) != -1) {
                this.mac.update(buffer);
            }
            fOutput.write(this.mac.doFinal());
            fInput.close();
            fOutput.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            return false;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        return true;
    }
}

