/* 
 * ThatIP-J Copyright 2003 Algenta Technologies All rights reserved.
 * Use is subject to license terms.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * $Id: Config.java,v 1.1 2003/12/08 11:48:05 dan Exp $
 * 
 * $Log: Config.java,v $
 * Revision 1.1  2003/12/08 11:48:05  dan
 * CrossIP initial commit
 *
 */
package com.algenta.crossip;

import java.util.Enumeration;
import java.util.Vector;

import com.algenta.thatip.Record;
import com.algenta.thatip.ThatIPConstants;

/**
 * @author Dan Smith (<a href="mailto:dan (is at) algenta (dot) com">dan (is at) algenta (dot) com</a>)
 *
 */
public class Config implements ThatIPConstants, CrossIPConstants{
	private Vector records = new Vector(5);
	private int serial = -1;
	private String username = "";
	private String password = "";
	private String updateFile = UPDATE_FILENAME;
	private String configFile = CONFIG_FILENAME;
	private String server = UPDATE_SERVER;
	private int port = UPDATE_PORT;
	private String nat = "n";
	
	private boolean updated = false;
	
	
	/**
	 * @param record
	 */
	public void addRecord(Record record) {
		records.add(record);
	}

	/**
	 * @param record
	 */
	public void addRecord(Record[] record) {
		for (int i = 0; i < record.length; ++i) {
			records.add(record[i]);
		}
	}
		
	/**
	 * @param record
	 */
	public void removeRecord(Record record) {
		records.remove(record);
	}
	
	/**
	 * @return
	 */
	public Record[] getRecords() {
		Record[] r = new Record[records.size()];
		for(int i = 0; i < records.size(); ++i) {
			r[i] = (Record) records.get(i);
		}
		return r;
	}
	
	/**
	 * 
	 */
	public void clearRecords(){
		records.clear();
	}
	/**
	 * @return
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * @return
	 */
	public int getPort() {
		return port;
	}

	/**
	 * @return
	 */
	public int getSerial() {
		return serial;
	}

	/**
	 * @return
	 */
	public String getServer() {
		return server;
	}

	/**
	 * @return
	 */
	public String getUpdateFile() {
		return updateFile;
	}

	/**
	 * @return
	 */
	public String getUsername() {
		return username;
	}

	/**
	 * @param string
	 */
	public void setPassword(String string) {
		password = string;
	}

	/**
	 * @param i
	 */
	public void setPort(int i) {
		port = i;
	}

	/**
	 * @param i
	 */
	public void setSerial(int i) {
		serial = i;
	}

	/**
	 * @param string
	 */
	public void setServer(String string) {
		server = string;
	}

	/**
	 * @param string
	 */
	public void setUpdateFile(String string) {
		updateFile = string;
	}

	/**
	 * @param string
	 */
	public void setUsername(String string) {
		username = string;
	}

	/**
	 * @return
	 */
	public boolean isUpdated() {
		return updated;
	}

	/**
	 * @param b
	 */
	public void setUpdated(boolean b) {
		updated = b;
	}

	/**
	 * @return
	 */
	public String getNat() {
		return nat;
	}

	/**
	 * @param string
	 */
	public void setNat(String string) {
		nat = string;
	}

	public String toString(){
		String s = "# thatip.config\n";
		s+=CONF_USERNAME + " " + username + "\n";
		s+=CONF_PASSWORD + " " + password + "\n";
		s+=CONF_UPDATEFILE + " " + updateFile+ "\n";
		s+=CONF_SERVER + " " + server+ "\n";
		s+=CONF_PORT + " " + port+ "\n";
		s+=CONF_NAT + " " + nat+ "\n";
		s+=CONF_SERIAL + " " + serial+ "\n";
		s+="#200 <hostname> <hosttype> <group> <optional static ip>"+ "\n";
		for(Enumeration e = records.elements(); e.hasMoreElements();) {
			Record r = (Record) e.nextElement();
			s+=r.toString() + "\n";
		}
		
		return s;
	}
	/**
	 * @return
	 */
	public String getConfigFile() {
		return configFile;
	}

	/**
	 * @param string
	 */
	public void setConfigFile(String string) {
		configFile = string;
	}

}
