/*
 * Decompiled with CFR 0.152.
 */
package com.algenta.thatip.impl;

import com.algenta.thatip.Record;
import com.algenta.thatip.ThatIPConstants;
import com.algenta.thatip.ThatIPServer;
import com.algenta.thatip.ThatIPServerException;
import com.algenta.thatip.ThatIPServerUpdateException;
import com.algenta.util.MD5Crypt3;
import com.algenta.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;

public class Server
implements ThatIPServer,
ThatIPConstants {
    private Socket socket = null;
    private PrintWriter out = null;
    private BufferedReader in = null;
    String clientName = "unknown";
    String clientVersion = "unknown";
    private String version = "";
    private String salt = "";
    private boolean login = false;
    private boolean connected = false;

    public void connect(String updateServer, int port) throws UnknownHostException, IOException, ThatIPServerException {
        this.socket = new Socket(updateServer, port);
        this.out = new PrintWriter(this.socket.getOutputStream(), true);
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        String welcome = this.in.readLine();
        String[] params = StringUtils.Split(welcome, "\t");
        if (params.length != 3) {
            throw new ThatIPServerException("Unknown welcome message");
        }
        this.version = params[1];
        this.salt = params[2];
        if (this.salt.length() != 11) {
            throw new ThatIPServerException("Unknown welcome message");
        }
        this.connected = true;
    }

    public void connect(String updateServer) throws UnknownHostException, IOException, ThatIPServerException {
        this.connect(updateServer, 3822);
    }

    public void connect() throws UnknownHostException, IOException, ThatIPServerException {
        this.connect("update.thatip.com", 3822);
    }

    public int login(String username, String reseller, String password) throws IOException, ThatIPServerUpdateException, NoSuchAlgorithmException {
        String hash = MD5Crypt3.MD5Hash(password.getBytes());
        return this.loginMD5(username, reseller, hash);
    }

    public int loginMD5(String username, String reseller, String md5) throws IOException, ThatIPServerUpdateException, NoSuchAlgorithmException {
        int serial;
        if (username == null) {
            throw new ThatIPServerUpdateException("username is null");
        }
        if (reseller == null) {
            throw new ThatIPServerUpdateException("reseller is null");
        }
        if (md5 == null) {
            throw new ThatIPServerUpdateException("mdr is null");
        }
        String md5crypt = MD5Crypt3.MD5Crypt(md5, this.salt);
        md5crypt = md5crypt.substring(md5crypt.lastIndexOf("$") + 1);
        this.out.println("l\t" + username + "\t" + md5crypt + "\t" + "1.1" + "\t" + reseller + "\t" + this.clientName + "\t" + this.clientVersion);
        String line = this.in.readLine();
        if (!line.startsWith("100")) {
            this.getServerError(line);
        }
        this.login = true;
        line = line.substring(line.indexOf("\t") + 1);
        try {
            serial = Integer.parseInt(line);
        }
        catch (NumberFormatException e) {
            serial = 0;
        }
        return serial;
    }

    public String update(String groupId) throws IOException, ThatIPServerUpdateException {
        return this.update(groupId, null);
    }

    public String update(String groupId, String ipAddr) throws IOException, ThatIPServerUpdateException {
        if (ipAddr != null) {
            this.out.println("u\t" + groupId + "\t" + ipAddr);
        } else {
            this.out.println("u\t" + groupId);
        }
        String line = this.in.readLine();
        if (line.startsWith("101\t")) {
            line = line.substring(4);
        } else {
            this.getServerError(line);
        }
        return line;
    }

    public String update(String[] groupId, String ipAddr) throws IOException, ThatIPServerUpdateException {
        String ip = "";
        int i = 0;
        while (i < groupId.length) {
            ip = this.update(groupId[i], ipAddr);
            ++i;
        }
        return ip;
    }

    public String update(String[] groupId) throws IOException, ThatIPServerUpdateException {
        return this.update(groupId, null);
    }

    public String update(Record record) throws IOException, ThatIPServerUpdateException {
        return this.update(record.getGroup(), null);
    }

    public String update(Record record, String ipAddr) throws IOException, ThatIPServerUpdateException {
        return this.update(record.getGroup(), ipAddr);
    }

    public Record[] getRecords() throws IOException, ThatIPServerUpdateException {
        this.out.println("h");
        String line = "";
        Vector<Record> records = new Vector<Record>(5);
        while (line.compareToIgnoreCase("201") != 0) {
            line = this.in.readLine();
            if (line.startsWith("200")) {
                Record record = new Record(line);
                records.add(record);
                continue;
            }
            if (line.startsWith("2")) continue;
            this.getServerError(line);
        }
        Record[] r = new Record[records.size()];
        int i = 0;
        while (i < records.size()) {
            r[i] = (Record)records.get(i);
            ++i;
        }
        return r;
    }

    private void getServerError(String line) throws ThatIPServerUpdateException {
        int code = 0;
        try {
            code = Integer.parseInt(line);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        String msg = "";
        switch (code) {
            case 400: {
                msg = "try again later";
                break;
            }
            case 500: {
                msg = "invalid username or password";
                break;
            }
            case 501: {
                msg = "thatIP registration period has expired";
                break;
            }
            case 502: {
                msg = "account locked / abuse";
                break;
            }
            case 503: {
                msg = "operation requires login";
                break;
            }
            case 504: {
                msg = "invalid command syntax";
                break;
            }
            case 520: {
                msg = "invalid host or group, no records found, update failed";
                break;
            }
            case 521: {
                msg = "invalid ip address";
                break;
            }
            case 522: {
                msg = "couldn't determine remote ip";
                break;
            }
            default: {
                msg = "Unknown error";
            }
        }
        throw new ThatIPServerUpdateException(msg, code);
    }

    public void quit() {
        block9: {
            block8: {
                this.out.println("q");
                this.login = false;
                this.connected = false;
                this.out.close();
                try {
                    this.in.close();
                }
                catch (IOException e) {
                    if (this.in == null) break block8;
                    try {
                        this.in.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            try {
                this.socket.close();
            }
            catch (IOException e1) {
                if (this.socket == null) break block9;
                try {
                    this.socket.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isAuthenticated() {
        return this.login;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public void setClientName(String string) {
        this.clientName = string;
    }

    public void setClientVersion(String string) {
        this.clientVersion = string;
    }
}

