/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.ValueFormatException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.StringTokenizer;

public class AirportInfoRecord {
    public static final int CHAR_STRING = 0;
    public static final int IP_ADDRESS = 1;
    public static final int BYTE_STRING = 2;
    public static final int PHONE_NUMBER = 3;
    public static final int UNSIGNED_INTEGER = 4;
    public static final int BYTE = 5;
    public static final int LITTLE_ENDIAN_UNSIGNED_INTEGER = 6;
    public static final int UNENCRYPTED = 0;
    public static final int ENCRYPTED = 2;
    public String tag;
    public String description;
    public int dataType;
    public int encryption;
    public int maxLength;
    public byte[] value;
    public static byte[] cipherBytes = new byte[]{14, 57, -8, 5, -60, 1, 85, 79, 12, -84, -123, 125, -122, -118, -75, 23, 62, 9, -56, 53, -12, 49, 101, 127, 60, -100, -75, 109, -106, -102, -91, 7, 46, 25, -40, 37, -28, 33, 117, 111, 44, -116, -91, -99, 102, 106, 85, -9, -34, -23, 40, -43, 20, -47, -123, -97, -36, 124, 85, -115, 118, 122, 69, -25, -50, -7, 56, -59, 4, -63, -107, -113, -52, 108, 69, -67, 70, 74, 117, -41, -2, -55, 8, -11, 52, -15, -91, -65, -4, 92, 117, -83, 86, 90, 101, -57, -18, -39, 24, -27, 36, -31, -75, -81, -20, 76, 101, -35, 38, 42, 21, -73, -98, -87, 104, -107, 84, -111, -59, -33, -100, 60, 21, -51, 54, 58, 5, -89, -114, -71, 120, -123, 68, -127, -43, -49, -116, 44, 5, -3, 6, 10, 53, -105, -66, -119, 72, -75, 116, -79, -27, -1, -68, 28, 53, -19, 22, 26, 37, -121, -82, -103, 88, -91, 100, -95, -11, -17, -84, 12, 37, 29, -26, -22, -43, 119, 94, 105, -88, 85, -108, 81, 5, 31, 92, -4, -43, 13, -10, -6, -59, 103, 78, 121, -72, 69, -124, 65, 21, 15, 76, -20, -59, 61, -58, -54, -11, 87, 126, 73, -120, 117, -76, 113, 37, 63, 124, -36, -11, 45, -42, -38, -27, 71, 110, 89, -104, 101, -92, 97, 53, 47, 108, -52, -27, 93, -90, -86, -107, 55, 30, 41, -24, 21, -44, 17, 69, 95, 28, -68, -107, 77, -74, -70, -123, 39};

    public AirportInfoRecord(String tag, String description, int dataType, int encryption, int maxLength, byte[] value) {
        this.tag = tag;
        this.description = description;
        this.dataType = dataType;
        this.encryption = encryption;
        this.maxLength = maxLength;
        this.value = value;
    }

    public AirportInfoRecord(String tag, String description, int dataType, int encryption, int maxLength) {
        this.tag = tag;
        this.description = description;
        this.maxLength = maxLength;
        this.dataType = dataType;
        this.encryption = encryption;
        this.value = new byte[maxLength];
    }

    public AirportInfoRecord() {
        this.tag = "";
        this.description = "";
        this.dataType = 0;
        this.encryption = 0;
        this.maxLength = 0;
        this.value = new byte[0];
    }

    public void clearWindow() {
        this.value = new byte[0];
    }

    public String toString() {
        String returnString = new String();
        byte[] bytes = this.value;
        switch (this.dataType) {
            case 4: {
                try {
                    returnString = this.convertToUnsignedInteger(bytes);
                }
                catch (NumberFormatException numberFormatException) {
                    returnString = this.hexBytes(bytes);
                }
                break;
            }
            case 6: {
                try {
                    bytes = this.reverseBytes(bytes);
                    returnString = this.convertToUnsignedInteger(bytes);
                }
                catch (NumberFormatException numberFormatException) {
                    returnString = this.hexBytes(bytes);
                }
                break;
            }
            case 0: 
            case 3: {
                returnString = this.convertToCharString(bytes);
                break;
            }
            case 1: {
                returnString = this.convertToIPAddress(bytes);
                break;
            }
            default: {
                returnString = this.hexBytes(bytes);
            }
        }
        return returnString;
    }

    private String convertToCharString(byte[] bytes) {
        String charString;
        if (bytes.length == 0) {
            charString = "";
        } else {
            charString = new String(bytes);
            int endIndex = charString.indexOf(0);
            if (endIndex >= 0) {
                charString = charString.substring(0, endIndex);
            }
        }
        return charString;
    }

    private String convertToUnsignedInteger(byte[] bytes) {
        BigInteger bigInt = new BigInteger(1, bytes);
        return bigInt.toString();
    }

    private String convertToIPAddress(byte[] bytes) {
        int value;
        String returnString = new String();
        int i = 0;
        while (i < bytes.length - 1) {
            value = bytes[i];
            if (value < 0) {
                value += 256;
            }
            returnString = String.valueOf(returnString) + value + ".";
            ++i;
        }
        value = bytes[bytes.length - 1];
        if (value < 0) {
            value += 256;
        }
        returnString = String.valueOf(returnString) + value;
        return returnString;
    }

    public void setBytesFromString(String valueString) throws ValueFormatException {
        byte[] bytes;
        switch (this.dataType) {
            case 4: {
                bytes = this.convertFromUnsignedInteger(valueString);
                break;
            }
            case 6: {
                bytes = this.convertFromUnsignedInteger(valueString);
                bytes = this.reverseBytes(bytes);
                break;
            }
            case 0: 
            case 3: {
                if (valueString.length() > this.maxLength - 1) {
                    throw new ValueFormatException("Maximum " + (this.maxLength - 1) + " characters.");
                }
                bytes = valueString.getBytes();
                break;
            }
            case 1: {
                bytes = this.convertFromIPv4Address(valueString);
                break;
            }
            default: {
                bytes = this.convertFromHexString(valueString);
            }
        }
        this.value = bytes;
    }

    /*
     * Unable to fully structure code
     */
    private byte[] convertFromIPv4Address(String addressString) throws ValueFormatException {
        bytes = new byte[this.maxLength];
        i = 0;
        st = new StringTokenizer(addressString, ".");
        if (st.countTokens() == this.maxLength) ** GOTO lbl18
        if (st.countTokens() == 4) {
            throw new ValueFormatException("Bad IP address: must be of form a.b.c.d, with a,b,c and d between 0 and 255.");
        }
        throw new ValueFormatException("Bad dotted address supplied: should have " + this.maxLength + " components.");
lbl-1000:
        // 1 sources

        {
            try {
                component = st.nextToken();
                value = Integer.parseInt(component);
                if (value < 0 || value > 255) {
                    throw new ValueFormatException("Bad IP address: must be of form a.b.c.d, with a,b,c and d between 0 and 255.");
                }
                bytes[i] = (byte)value;
                ++i;
                continue;
            }
            catch (NumberFormatException v0) {
                throw new ValueFormatException("Bad IP address: must be of form a.b.c.d, with a,b,c and d between 0 and 255.");
            }
lbl18:
            // 2 sources

            ** while (st.hasMoreTokens())
        }
lbl19:
        // 1 sources

        return bytes;
    }

    private byte[] convertFromUnsignedInteger(String valueString) throws ValueFormatException {
        int length = this.maxLength;
        byte[] bytes = new byte[length];
        try {
            int minValue = 0;
            long maxValue = 1L;
            int i = 0;
            while (i < length) {
                maxValue *= 256L;
                ++i;
            }
            long value = Long.parseLong(valueString);
            if (value < (long)minValue || value > --maxValue) {
                throw new ValueFormatException("Value must be between " + minValue + " and " + maxValue + ".");
            }
            int i2 = 0;
            while (i2 < length) {
                bytes[length - i2 - 1] = (byte)(value % 256L);
                value /= 256L;
                ++i2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValueFormatException("Bad number format.");
        }
        return bytes;
    }

    private byte[] convertFromHexString(String hexString) throws ValueFormatException {
        int index;
        byte[] bytes = new byte[this.maxLength];
        hexString.trim();
        while ((index = hexString.indexOf(32)) != -1) {
            hexString = String.valueOf(hexString.substring(0, index)) + hexString.substring(index + 1);
        }
        if (2 * (hexString.length() / 2) != hexString.length()) {
            throw new ValueFormatException("Must have an even number of hexadecimal digits.");
        }
        if (this.maxLength > 0 && hexString.length() / 2 != this.maxLength) {
            throw new ValueFormatException("Too many hexadecimal digits (must have " + 2 * this.maxLength + " hex digits).");
        }
        int i = 0;
        while (i < hexString.length() / 2) {
            String digitString = hexString.substring(2 * i, 2 * i + 2);
            try {
                int value = Integer.parseInt(digitString, 16);
                bytes[i] = (byte)value;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ValueFormatException("Entries must be hexadecimal digits (0 through 9 and a through f or A through F) or spaces.");
            }
            ++i;
        }
        return bytes;
    }

    private byte[] reverseBytes(byte[] inBytes) {
        int length = inBytes.length;
        byte[] outBytes = new byte[length];
        int i = 0;
        while (i < length) {
            outBytes[i] = inBytes[length - i - 1];
            ++i;
        }
        return outBytes;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] bytes) {
        this.value = bytes;
    }

    public byte[] getUpdateBytes() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream outStream = new DataOutputStream(byteStream);
        try {
            outStream.writeBytes(this.tag);
            outStream.writeInt(this.encryption);
            outStream.writeInt(this.value.length);
            if (this.value.length > 0) {
                if (this.encryption == 2) {
                    outStream.write(AirportInfoRecord.encryptBytes(cipherBytes, this.value));
                } else {
                    outStream.write(this.value);
                }
            }
        }
        catch (IOException iOException) {}
        return byteStream.toByteArray();
    }

    public byte[] getRequestBytes() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(128);
        DataOutputStream outStream = new DataOutputStream(byteStream);
        try {
            outStream.writeBytes(this.tag);
            outStream.writeInt(this.encryption);
            outStream.writeInt(0);
        }
        catch (IOException iOException) {}
        return byteStream.toByteArray();
    }

    public static byte[] decryptBytes(byte[] cipherString, byte[] encryptedString) {
        byte[] returnBytes = new byte[encryptedString.length];
        int length = encryptedString.length;
        int i = 0;
        while (i < length) {
            returnBytes[i] = (byte)(encryptedString[i] ^ cipherString[i % 256]);
            ++i;
        }
        return returnBytes;
    }

    public static byte[] encryptBytes(byte[] cipherString, byte[] encryptedString) {
        return AirportInfoRecord.decryptBytes(cipherString, encryptedString);
    }

    private int getIntegerValue(byte[] valueBytes) {
        int value = 0;
        int i = 0;
        while (i < valueBytes.length) {
            int absValue = valueBytes[i];
            if (absValue < 0) {
                absValue += 256;
            }
            value = value * 256 + absValue;
            ++i;
        }
        return value;
    }

    private String hexByte(byte b) {
        int pos = b;
        if (pos < 0) {
            pos += 256;
        }
        String returnString = new String();
        returnString = String.valueOf(returnString) + Integer.toHexString(pos / 16);
        returnString = String.valueOf(returnString) + Integer.toHexString(pos % 16);
        return returnString;
    }

    private String hexBytes(byte[] bytes) {
        String returnString = new String();
        int i = 0;
        while (i < bytes.length) {
            returnString = String.valueOf(returnString) + this.hexByte(bytes[i]);
            ++i;
        }
        return returnString;
    }
}

