/*
 * Decompiled with CFR 0.152.
 */
package snmp;

import java.util.StringTokenizer;
import snmp.SNMPBadValueException;
import snmp.SNMPOctetString;

public class SNMPNSAPAddress
extends SNMPOctetString {
    protected byte tag = (byte)69;

    public SNMPNSAPAddress() {
        this.data = new byte[6];
        int n = 0;
        while (n < 6) {
            this.data[n] = 0;
            ++n;
        }
    }

    public SNMPNSAPAddress(byte[] byArray) throws SNMPBadValueException {
        if (byArray.length != 6) {
            throw new SNMPBadValueException(" NSAPAddress: bad BER encoding supplied to set value ");
        }
        this.data = byArray;
    }

    public void setValue(Object object) throws SNMPBadValueException {
        if (object instanceof byte[] && ((byte[])object).length == 6) {
            this.data = (byte[])object;
        } else if (object instanceof String) {
            this.data = this.parseNSAPAddress((String)object);
        } else {
            throw new SNMPBadValueException(" NSAPAddress: bad length byte string supplied to set value ");
        }
    }

    public String toString() {
        String string = new String();
        if (this.data.length > 0) {
            int n = this.data[0];
            if (n < 0) {
                n += 256;
            }
            string = String.valueOf(string) + Integer.toHexString(n);
            int n2 = 1;
            while (n2 < this.data.length) {
                n = this.data[n2];
                if (n < 0) {
                    n += 256;
                }
                string = String.valueOf(string) + "-" + Integer.toHexString(n);
                ++n2;
            }
        }
        return string;
    }

    private byte[] parseNSAPAddress(String string) throws SNMPBadValueException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " .-");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                ++n;
                stringTokenizer.nextToken();
            }
            if (n != 6) {
                throw new SNMPBadValueException(" NSAPAddress: wrong number of components supplied to set value ");
            }
            byte[] byArray = new byte[n];
            stringTokenizer = new StringTokenizer(string, " .-");
            int n2 = 0;
            while (n2 < n) {
                int n3 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                if (n3 < 0 || n3 > 255) {
                    throw new SNMPBadValueException(" NSAPAddress: invalid component supplied to set value ");
                }
                byArray[n2] = (byte)n3;
                ++n2;
            }
            return byArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SNMPBadValueException(" NSAPAddress: invalid component supplied to set value ");
        }
    }
}

