/*
 * Decompiled with CFR 0.152.
 */
package byteblock;

import byteblock.ByteBlock;
import byteblock.ByteBlockWindow;

public class ByteBlockRectangularWindow
extends ByteBlockWindow {
    protected int numRows;
    protected int numCols;
    protected int baseStartIndex;

    public ByteBlockRectangularWindow(ByteBlock byteBlock) {
        this.numRows = byteBlock.numRows;
        this.numCols = byteBlock.numCols;
        this.baseStartIndex = 0;
        this.baseBlock = byteBlock;
    }

    public ByteBlockRectangularWindow(int n, int n2, int n3, ByteBlock byteBlock) {
        this.numRows = n2;
        this.numCols = n3;
        this.baseStartIndex = n;
        this.baseBlock = byteBlock;
    }

    public int getSize() {
        return this.numRows * this.numCols;
    }

    public byte[] getBytes() {
        return this.getBytes(0, this.numRows * this.numCols);
    }

    public byte[] getBytes(int n, int n2) {
        if (n2 > this.numRows * this.numCols) {
            n2 = this.numRows * this.numCols;
        }
        byte[] byArray = new byte[n2 - n];
        int n3 = this.baseStartIndex / this.baseBlock.numCols;
        int n4 = this.baseStartIndex - n3 * this.baseBlock.numCols;
        int n5 = n;
        while (n5 < n2) {
            int n6 = n5 / this.numCols;
            int n7 = n5 - n6 * this.numCols;
            int n8 = n7 + n4 + (n6 + n3) * this.baseBlock.numCols;
            byArray[n5 - n] = this.baseBlock.bytes[n8];
            ++n5;
        }
        return byArray;
    }

    public void clearBytes() {
        this.clearBytes(0, this.numRows * this.numCols);
    }

    public void clearBytes(int n, int n2) {
        if (n2 > this.numRows * this.numCols) {
            n2 = this.numRows * this.numCols;
        }
        int n3 = this.baseStartIndex / this.baseBlock.numCols;
        int n4 = this.baseStartIndex - n3 * this.baseBlock.numCols;
        int n5 = n;
        while (n5 < n2) {
            int n6 = n5 / this.numCols;
            int n7 = n5 - n6 * this.numCols;
            int n8 = n7 + n4 + (n6 + n3) * this.baseBlock.numCols;
            this.baseBlock.bytes[n8] = 0;
            ++n5;
        }
    }

    public void writeBytes(byte[] byArray) {
        this.writeBytes(0, byArray);
    }

    public void writeBytes(int n, byte[] byArray) {
        this.clearBytes();
        int n2 = n + byArray.length;
        if (n2 > this.numRows * this.numCols) {
            n2 = this.numRows * this.numCols;
        }
        int n3 = this.baseStartIndex / this.baseBlock.numCols;
        int n4 = this.baseStartIndex - n3 * this.baseBlock.numCols;
        int n5 = n;
        while (n5 < n2) {
            int n6 = n5 / this.numCols;
            int n7 = n5 - n6 * this.numCols;
            int n8 = n7 + n4 + (n6 + n3) * this.baseBlock.numCols;
            this.baseBlock.bytes[n8] = byArray[n5 - n];
            ++n5;
        }
    }

    public String toString() {
        return this.toString(0, this.numRows * this.numCols);
    }

    public String toString(int n, int n2) {
        String string = new String();
        int n3 = this.baseStartIndex / this.baseBlock.numCols;
        int n4 = this.baseStartIndex - n3 * this.baseBlock.numCols;
        int n5 = n;
        while (n5 < n2) {
            int n6 = n5 / this.numCols;
            int n7 = n5 - n6 * this.numCols;
            int n8 = n7 + n4 + (n6 + n3) * this.baseBlock.numCols;
            int n9 = this.baseBlock.bytes[n8];
            if (n9 < 0) {
                n9 += 256;
            }
            string = String.valueOf(string) + this.getHex(n9) + " ";
            if (n7 == this.numCols - 1) {
                string = String.valueOf(string) + "\n";
            }
            ++n5;
        }
        return string;
    }

    public String toHexString() {
        return this.toHexString(0, this.numRows * this.numCols);
    }

    public String toHexString(int n, int n2) {
        String string = new String();
        int n3 = this.baseStartIndex / this.baseBlock.numCols;
        int n4 = this.baseStartIndex - n3 * this.baseBlock.numCols;
        int n5 = n;
        while (n5 < n2) {
            int n6 = n5 / this.numCols;
            int n7 = n5 - n6 * this.numCols;
            int n8 = n7 + n4 + (n6 + n3) * this.baseBlock.numCols;
            int n9 = this.baseBlock.bytes[n8];
            if (n9 < 0) {
                n9 += 256;
            }
            string = String.valueOf(string) + this.getHex(n9);
            ++n5;
        }
        return string;
    }
}

