/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfo;
import airport.AirportInfoPanel;
import airport.AirportInfoRecord;
import airport.ValueFormatException;
import byteblock.ByteBlock;
import byteblock.ByteBlockMultiWindow;
import byteblock.ByteBlockRectangularWindow;
import byteblock.ByteBlockWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class AirportSNMPAccessControlTable
extends AirportInfoPanel {
    private AirportInfo airportInfo;
    private Vector addressVector;
    private JTable table;
    private AbstractTableModel tableModel;
    private JComboBox interfaceComboBox;
    private Hashtable interfaceNameToNumberHashtable;
    private Hashtable interfaceNumberToNameHashtable;

    public AirportSNMPAccessControlTable(AirportInfo airportInfo) {
        this.airportInfo = airportInfo;
        this.interfaceComboBox = new JComboBox();
        this.interfaceComboBox.addItem("All");
        this.interfaceComboBox.addItem("Ethernet");
        this.interfaceComboBox.addItem("Wireless");
        this.interfaceComboBox.addItem("Modem");
        this.interfaceNameToNumberHashtable = new Hashtable();
        this.interfaceNameToNumberHashtable.put("Ethernet", "0");
        this.interfaceNameToNumberHashtable.put("Wireless", "1");
        this.interfaceNameToNumberHashtable.put("Modem", "2");
        this.interfaceNameToNumberHashtable.put("All", "65535");
        this.interfaceNumberToNameHashtable = new Hashtable();
        this.interfaceNumberToNameHashtable.put("0", "Ethernet");
        this.interfaceNumberToNameHashtable.put("1", "Wireless");
        this.interfaceNumberToNameHashtable.put("2", "Modem");
        this.interfaceNumberToNameHashtable.put("65535", "All");
        this.setUpDisplay();
    }

    private void setUpDisplay() {
        this.refreshDisplay();
    }

    public void writeValue() throws ValueFormatException {
        String string;
        Object object;
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        ByteBlock byteBlock = this.airportInfo.baseBlock;
        int n = 1592;
        int n2 = 1;
        int n3 = 50;
        int n4 = 2;
        AirportInfoRecord airportInfoRecord = new AirportInfoRecord(n, n2, n3, n4, byteBlock);
        airportInfoRecord.clearWindow();
        int n5 = 0;
        int n6 = 1592;
        int n7 = 1;
        int n8 = 2;
        int n9 = 1602;
        int n10 = 1;
        int n11 = 2;
        int n12 = 1;
        int n13 = 1612;
        int n14 = 1;
        int n15 = 2;
        int n16 = 1622;
        int n17 = 1;
        int n18 = 2;
        int n19 = 1;
        int n20 = 1632;
        int n21 = 1;
        int n22 = 2;
        int n23 = 6;
        int n24 = 0;
        while (n24 < this.addressVector.size()) {
            object = ((String[])this.addressVector.elementAt(n24))[0];
            string = ((String[])this.addressVector.elementAt(n24))[1];
            String string2 = ((String[])this.addressVector.elementAt(n24))[2];
            if (!((String)object).equals("")) {
                AirportInfoRecord airportInfoRecord2;
                ByteBlockRectangularWindow byteBlockRectangularWindow;
                Object object2;
                Object object3;
                try {
                    object3 = new ByteBlockMultiWindow();
                    object2 = new ByteBlockRectangularWindow(n6, n7, n8, byteBlock);
                    ((ByteBlockMultiWindow)object3).addWindow((ByteBlockWindow)object2);
                    byteBlockRectangularWindow = new ByteBlockRectangularWindow(n9, n10, n11, byteBlock);
                    ((ByteBlockMultiWindow)object3).addWindow(byteBlockRectangularWindow);
                    airportInfoRecord2 = new AirportInfoRecord(n12, (ByteBlockWindow)object3);
                    airportInfoRecord2.setBytesFromString((String)object);
                }
                catch (ValueFormatException valueFormatException) {
                    this.table.editCellAt(n24, 0);
                    throw valueFormatException;
                }
                try {
                    object3 = new ByteBlockMultiWindow();
                    object2 = new ByteBlockRectangularWindow(n13, n14, n15, byteBlock);
                    ((ByteBlockMultiWindow)object3).addWindow((ByteBlockWindow)object2);
                    byteBlockRectangularWindow = new ByteBlockRectangularWindow(n16, n17, n18, byteBlock);
                    ((ByteBlockMultiWindow)object3).addWindow(byteBlockRectangularWindow);
                    airportInfoRecord2 = new AirportInfoRecord(n19, (ByteBlockWindow)object3);
                    airportInfoRecord2.setBytesFromString(string);
                }
                catch (ValueFormatException valueFormatException) {
                    this.table.editCellAt(n24, 1);
                    throw valueFormatException;
                }
                try {
                    object3 = new AirportInfoRecord(n20, n21, n22, n23, byteBlock);
                    object2 = (String)this.interfaceNameToNumberHashtable.get(string2);
                    ((AirportInfoRecord)object3).setBytesFromString((String)object2);
                }
                catch (ValueFormatException valueFormatException) {
                    this.table.editCellAt(n24, 2);
                    throw valueFormatException;
                }
                n6 += 2;
                n9 += 2;
                n13 += 2;
                n16 += 2;
                n20 += 2;
                ++n5;
            }
            ++n24;
        }
        object = this.airportInfo.get("SNMP access control list length");
        string = new String();
        string = String.valueOf(string) + n5;
        ((AirportInfoRecord)object).setBytesFromString(string);
    }

    public void refreshDisplay() {
        Object object;
        ByteBlock byteBlock = this.airportInfo.baseBlock;
        AirportInfoRecord airportInfoRecord = this.airportInfo.get("SNMP access control list length");
        String string = airportInfoRecord.toString();
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Problem with number of SNMP access control entries");
        }
        this.addressVector = new Vector();
        int n2 = 1592;
        int n3 = 1;
        int n4 = 2;
        int n5 = 1602;
        int n6 = 1;
        int n7 = 2;
        int n8 = 1;
        int n9 = 1612;
        int n10 = 1;
        int n11 = 2;
        int n12 = 1622;
        int n13 = 1;
        int n14 = 2;
        int n15 = 1;
        int n16 = 1632;
        int n17 = 1;
        int n18 = 2;
        int n19 = 6;
        int n20 = 0;
        while (n20 < n) {
            object = new ByteBlockMultiWindow();
            ByteBlockRectangularWindow byteBlockRectangularWindow = new ByteBlockRectangularWindow(n2, n3, n4, byteBlock);
            ((ByteBlockMultiWindow)object).addWindow(byteBlockRectangularWindow);
            ByteBlockRectangularWindow byteBlockRectangularWindow2 = new ByteBlockRectangularWindow(n5, n6, n7, byteBlock);
            ((ByteBlockMultiWindow)object).addWindow(byteBlockRectangularWindow2);
            AirportInfoRecord airportInfoRecord2 = new AirportInfoRecord(n8, (ByteBlockWindow)object);
            ByteBlockMultiWindow byteBlockMultiWindow = new ByteBlockMultiWindow();
            ByteBlockRectangularWindow byteBlockRectangularWindow3 = new ByteBlockRectangularWindow(n9, n10, n11, byteBlock);
            byteBlockMultiWindow.addWindow(byteBlockRectangularWindow3);
            ByteBlockRectangularWindow byteBlockRectangularWindow4 = new ByteBlockRectangularWindow(n12, n13, n14, byteBlock);
            byteBlockMultiWindow.addWindow(byteBlockRectangularWindow4);
            AirportInfoRecord airportInfoRecord3 = new AirportInfoRecord(n15, byteBlockMultiWindow);
            AirportInfoRecord airportInfoRecord4 = new AirportInfoRecord(n16, n17, n18, n19, byteBlock);
            String[] stringArray = new String[3];
            stringArray[0] = airportInfoRecord2.toString();
            stringArray[1] = airportInfoRecord3.toString();
            String string2 = airportInfoRecord4.toString();
            System.out.println("Interface number: " + string2);
            stringArray[2] = (String)this.interfaceNumberToNameHashtable.get(string2);
            System.out.println("Interface value: " + stringArray[2]);
            this.addressVector.insertElementAt(stringArray, this.addressVector.size());
            n2 += 2;
            n5 += 2;
            n9 += 2;
            n12 += 2;
            n16 += 2;
            ++n20;
        }
        this.removeAll();
        this.tableModel = new AccessAddressTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setCellSelectionEnabled(true);
        this.table.getColumn("Interface").setCellEditor(new DefaultCellEditor(this.interfaceComboBox));
        this.table.setPreferredScrollableViewportSize(new Dimension(300, 80));
        object = new JScrollPane(this.table);
        this.add((Component)object);
    }

    private class AccessAddressTableModel
    extends AbstractTableModel {
        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return 5;
        }

        public boolean isCellEditable(int n, int n2) {
            return n <= AirportSNMPAccessControlTable.this.addressVector.size();
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "IP address";
                }
                case 1: {
                    return "Address mask";
                }
            }
            return "Interface";
        }

        public Class getColumnClass(int n) {
            String string = "";
            return string.getClass();
        }

        public Object getValueAt(int n, int n2) {
            if (n < AirportSNMPAccessControlTable.this.addressVector.size()) {
                return ((String[])AirportSNMPAccessControlTable.this.addressVector.elementAt(n))[n2];
            }
            return "";
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n < AirportSNMPAccessControlTable.this.addressVector.size()) {
                String[] stringArray = (String[])AirportSNMPAccessControlTable.this.addressVector.elementAt(n);
                stringArray[n2] = (String)object;
            } else {
                String[] stringArray = new String[]{"", "", ""};
                stringArray[n2] = (String)object;
                AirportSNMPAccessControlTable.this.addressVector.insertElementAt(stringArray, AirportSNMPAccessControlTable.this.addressVector.size());
            }
            this.fireTableCellUpdated(n, n2);
        }

        AccessAddressTableModel() {
        }
    }
}

