/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportDiscoveryInfo;
import byteblock.ByteBlock;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import snmp.SNMPv1CommunicationInterface;

public class AirportDiscoverer
extends JFrame
implements ActionListener,
Runnable {
    JButton stopDiscoveryButton;
    JButton closeButton;
    JTextArea theArea;
    SNMPv1CommunicationInterface comInterface;
    Thread discoveryThread;

    public AirportDiscoverer() {
        this.setUpDisplay();
        this.pack();
        this.show();
        this.discoveryThread = new Thread(this);
        this.discoveryThread.start();
    }

    private void setUpDisplay() {
        Insets insets;
        this.setTitle("Base Station Discovery");
        this.stopDiscoveryButton = new JButton("Stop Discovery");
        this.stopDiscoveryButton.setActionCommand("stop discovery");
        this.stopDiscoveryButton.addActionListener(this);
        this.closeButton = new JButton("Close");
        this.closeButton.setActionCommand("close");
        this.closeButton.addActionListener(this);
        this.theArea = new JTextArea(20, 60);
        this.theArea.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(this.theArea);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.stopDiscoveryButton, gridBagConstraints);
        jPanel.add(this.stopDiscoveryButton);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.closeButton, gridBagConstraints);
        jPanel.add(this.closeButton);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add("North", jPanel);
        this.getContentPane().add("Center", jScrollPane);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            if (string == "close") {
                this.discoveryThread.interrupt();
                this.hide();
                this.dispose();
            }
            if (string == "stop discovery") {
                this.discoveryThread.interrupt();
            }
        }
        catch (Exception exception) {}
    }

    public void run() {
        try {
            DatagramSocket datagramSocket = new DatagramSocket();
            datagramSocket.setSoTimeout(1000);
            int n = 192;
            InetAddress inetAddress = InetAddress.getByName("255.255.255.255");
            byte[] byArray = new byte[116];
            byArray[0] = 1;
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
            datagramSocket.send(datagramPacket);
            while (!Thread.interrupted()) {
                DatagramPacket datagramPacket2 = new DatagramPacket(byArray, byArray.length);
                try {
                    datagramSocket.receive(datagramPacket2);
                    byArray = datagramPacket2.getData();
                    int n2 = 8;
                    int n3 = 16;
                    ByteBlock byteBlock = new ByteBlock(n2, n3, byArray);
                    AirportDiscoveryInfo airportDiscoveryInfo = new AirportDiscoveryInfo(byteBlock);
                    long l = Long.parseLong(airportDiscoveryInfo.get("Base station uptime").toString());
                    long l2 = (l /= 100L) / 86400L;
                    long l3 = l / 3600L % 24L;
                    long l4 = l / 60L % 60L;
                    long l5 = l % 60L;
                    String string = new String();
                    string = String.valueOf(string) + l2;
                    String string2 = new String();
                    string2 = String.valueOf(string2) + l3;
                    if (string2.length() < 2) {
                        string2 = "0" + string2;
                    }
                    String string3 = new String();
                    if ((string3 = String.valueOf(string3) + l4).length() < 2) {
                        string3 = "0" + string3;
                    }
                    String string4 = new String();
                    if ((string4 = String.valueOf(string4) + l5).length() < 2) {
                        string4 = "0" + string4;
                    }
                    String string5 = String.valueOf(string) + ":" + string2 + ":" + string3;
                    this.theArea.append("Reply received:\n");
                    this.theArea.append("Device address:   " + airportDiscoveryInfo.get("Base station IP address").toString() + "\n");
                    this.theArea.append("Device MAC:     " + airportDiscoveryInfo.get("Base station Mac address").toString() + "\n");
                    this.theArea.append("Device name:    " + airportDiscoveryInfo.get("Base station name").toString() + "\n");
                    this.theArea.append("Device type:    " + airportDiscoveryInfo.get("Device identifying string").toString() + "\n");
                    this.theArea.append("Device uptime (days:hrs:mins):   " + string5 + "\n");
                    this.theArea.append("\n");
                }
                catch (InterruptedIOException interruptedIOException) {}
            }
        }
        catch (Exception exception) {
            this.theArea.append("Exception during discovery: " + exception + "\n");
        }
        this.theArea.append("Discovery finished.\n");
    }

    private String hexByte(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        String string = new String();
        string = String.valueOf(string) + Integer.toHexString(n2 / 16);
        string = String.valueOf(string) + Integer.toHexString(n2 % 16);
        return string;
    }
}

