package net.psammead.mwapi.yurik;

import net.psammead.mwapi.yurik.data.list.WatchListResult;
import net.psammead.mwapi.yurik.data.list.WatchList_item;
import net.psammead.mwapi.yurik.data.list.WatchList_watchlist;
import net.psammead.mwapi.yurik.data.prop.TemplatesResult;
import net.psammead.mwapi.yurik.data.prop.Templates_page;
import net.psammead.mwapi.yurik.data.prop.Templates_templates;
import net.psammead.mwapi.yurik.data.prop.Templates_tl;
import net.psammead.mwapi.yurik.json.Copy;
import net.psammead.mwapi.yurik.json.CreateObj;
import net.psammead.mwapi.yurik.json.ExistsToBool;
import net.psammead.mwapi.yurik.json.IsoToDate;
import net.psammead.mwapi.yurik.json.JSONConverter;
import net.psammead.mwapi.yurik.json.ListIter;
import net.psammead.mwapi.yurik.json.LongToInt;
import net.psammead.mwapi.yurik.json.MapEntry;
import net.psammead.mwapi.yurik.json.MapValuesIter;
import net.psammead.mwapi.yurik.json.NullSafe;
import net.psammead.mwapi.yurik.json.TitleToLocation;

/** temporary notes */
public class YurikShortForm {
	public static final JSONConverter	TEMPLATES_CONVERTER_2	=
		propConv(
			TemplatesResult.class,
			Templates_page.class,
			"templates",
			Templates_templates.class,
			new CreateObj(Templates_tl.class,
				new MapEntry("title",	new TitleToLocation())));
	
	public static final JSONConverter	WATCHLIST_CONVERTER_2	= 
		listConv(
			WatchListResult.class, 
			"watchlist",	
			WatchList_watchlist.class,
			new CreateObj(WatchList_item.class,
				new MapEntry("title",		new TitleToLocation()),
				new MapEntry("pageid",		new Copy()),
				new MapEntry("revid",		new Copy()),
				new MapEntry("timestamp",	new IsoToDate()),
				new MapEntry("new",			new ExistsToBool()),
				new MapEntry("minor",		new ExistsToBool()),
				new MapEntry("anon",		new ExistsToBool()),
				new MapEntry("type",		new Copy()),
				new MapEntry("user",		new Copy()),
				new MapEntry("oldlen",		new LongToInt()),
				new MapEntry("newlen",		new LongToInt()),
				new MapEntry("comment",		new Copy())),
			"wlstart", 
			new IsoToDate());
	
	private static final JSONConverter propConv(
			Class<?> resultClass,
			Class<?> pageClass,
			String listName,
			Class<?> listClass,
			JSONConverter itemConv) {
		return 
		new CreateObj(resultClass,
			new MapEntry("query", 
				new MapEntry("pages",
					new MapValuesIter(
						new CreateObj(pageClass,
							new MapEntry("title",		new TitleToLocation()),
							new MapEntry("pageid",		new Copy()),
							new MapEntry(listName, 
								new CreateObj(listClass,	new ListIter(itemConv))))))));
	}
	
	private static final JSONConverter listConv(
			Class<?> resultClass, 
			String listName, Class<?> listClass, 
			JSONConverter itemConverter, 
			String continueField, JSONConverter continueConverter) {
		return
		new CreateObj(resultClass,
			new MapEntry("query", 
				new CreateObj(listClass,
					new MapEntry(listName,
						new ListIter(
							itemConverter)))),
			new MapEntry("query-continue",
				new NullSafe(
					new MapEntry(listName,
						new MapEntry(continueField,
								continueConverter)))));
	}
}
