/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.ui.action;

import net.psammead.mwapi.MediaWiki;
import net.psammead.mwapi.MediaWikiException;
import net.psammead.mwapi.connection.Connection;
import net.psammead.mwapi.ui.action.UiSimpleActionBase;
import net.psammead.mwapi.ui.action.response.ResponseData;
import net.psammead.mwapi.ui.action.response.ResponseHandler;

public class UserLoginAction
extends UiSimpleActionBase {
    private boolean success = false;

    public UserLoginAction(MediaWiki mediaWiki, final Connection connection, final String user, String password, boolean remember) {
        super(mediaWiki, connection);
        this.simpleMethod(POST);
        this.simpleTitle(this.specialPage("Userlogin"));
        this.simpleArg("action", "submitlogin");
        this.simpleArg("wpName", user);
        this.simpleArg("wpPassword", password);
        this.simpleArg("wpRemember", remember ? "1" : "0");
        this.simpleArg("wpLoginattempt", "submit");
        this.simpleArg("wpSkipCookieCheck", "1");
        this.responseMessageHandler(200, "loginsuccess", new ResponseHandler(){

            public boolean handle(ResponseData data) throws MediaWikiException {
                connection.setUserName(user);
                connection.setLoggedIn(true);
                UserLoginAction.this.success = true;
                return true;
            }
        });
        this.responseMessageHandler(200, "wrongpassword", new ResponseHandler(){

            public boolean handle(ResponseData data) throws MediaWikiException {
                connection.setLoggedIn(false);
                UserLoginAction.this.success = false;
                return true;
            }
        });
        this.responseMessageHandler(200, "nosuchuser", new ResponseHandler(){

            public boolean handle(ResponseData data) throws MediaWikiException {
                connection.setLoggedIn(false);
                UserLoginAction.this.success = false;
                return true;
            }
        });
        this.responseHandler(302, new ResponseHandler(){

            public boolean handle(ResponseData data) throws MediaWikiException {
                connection.setUserName(user);
                connection.setLoggedIn(true);
                UserLoginAction.this.success = true;
                return true;
            }
        });
        this.responseLiteralHandler("var wgUserName = null;", new ResponseHandler(){

            public boolean handle(ResponseData data) throws MediaWikiException {
                connection.setLoggedIn(false);
                UserLoginAction.this.success = false;
                return true;
            }
        });
        this.responseHandler(200, new ResponseHandler(){

            public boolean handle(ResponseData data) throws MediaWikiException {
                connection.setLoggedIn(false);
                UserLoginAction.this.success = false;
                return true;
            }
        });
    }

    public boolean isSuccess() {
        return this.success;
    }
}

