/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.ui.action;

import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.FormFields;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.psammead.mwapi.MediaWiki;
import net.psammead.mwapi.MediaWikiException;
import net.psammead.mwapi.connection.Connection;
import net.psammead.mwapi.net.IllegalFormException;
import net.psammead.mwapi.net.JerichoUtil;
import net.psammead.mwapi.ui.MethodException;
import net.psammead.mwapi.ui.UnexpectedAnswerException;
import net.psammead.mwapi.ui.action.UiActionBase;
import net.psammead.mwapi.ui.action.response.ResponseData;
import net.psammead.mwapi.ui.action.response.ResponseHandler;
import net.psammead.mwapi.ui.action.response.ResponsePattern;
import net.psammead.mwapi.ui.action.response.ResponseSelect;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public abstract class UiFormActionBase
extends UiActionBase {
    private String fetchTitle = null;
    private Map<String, String> fetchArgs = new HashMap<String, String>();
    private String formName = null;
    private String formId = null;
    private int formIndex = -1;
    private Set<String> copyArgs = new HashSet<String>();
    private Map<String, String> actionArgs = new HashMap<String, String>();
    private ResponseSelect responseSelect = new ResponseSelect();

    protected UiFormActionBase(MediaWiki mediaWiki, Connection connection) {
        super(mediaWiki, connection);
    }

    protected void fetchTitle(String title) {
        this.fetchTitle = title;
    }

    protected void fetchArg(String name, String value) {
        if (value != null) {
            this.fetchArgs.put(name, value);
        } else {
            this.fetchArgs.remove(name);
        }
    }

    protected void formName(String name) {
        this.formName = name;
    }

    protected void formId(String id) {
        this.formId = id;
    }

    protected void formIndex(int index) {
        this.formIndex = index;
    }

    protected void copyArg(String name) {
        this.copyArgs.add(name);
    }

    protected void actionArg(String name, String value) {
        if (value != null) {
            this.actionArgs.put(name, value);
        } else {
            this.actionArgs.remove(name);
        }
    }

    protected void responseHandler(int responseCode, ResponseHandler handler) {
        this.responseSelect.register(new ResponsePattern(responseCode), handler);
    }

    protected void responseMessageHandler(int responseCode, String messageName, ResponseHandler handler) {
        Pattern regexp = this.messageRegexp(messageName);
        if (regexp == null) {
            throw new IllegalArgumentException("message not available: " + messageName);
        }
        this.responseSelect.register(new ResponsePattern(responseCode, regexp), handler);
    }

    protected void responseLiteralHandler(String literalText, ResponseHandler handler) {
        this.responseSelect.register(new ResponsePattern(literalText), handler);
    }

    public final void execute() throws MediaWikiException {
        GetMethod fetchMethod = null;
        PostMethod updateMethod = null;
        try {
            boolean handled;
            String fetchURL = this.urlManager.actionURL(this.fetchTitle, this.fetchArgs);
            this.connection.throttle();
            fetchMethod = this.createGetMethod(fetchURL, this.fetchArgs);
            int fetchResponseCode = this.client.executeMethod((HttpMethod)fetchMethod);
            String fetchResponseBody = fetchMethod.getResponseBodyAsString();
            this.debug((HttpMethod)fetchMethod);
            if (fetchResponseCode != 200) {
                throw new UnexpectedAnswerException("unexpected response code (FormAction)");
            }
            Source source = JerichoUtil.createSource(fetchResponseBody, this.logger);
            Element form = JerichoUtil.fetchForm((Segment)source, this.formName, this.formId, this.formIndex);
            FormFields fields = form.findFormFields();
            for (String key : this.copyArgs) {
                String value = JerichoUtil.fetchStringField(fields, key);
                this.actionArgs.put(key, value);
            }
            URL actionURL = JerichoUtil.fetchActionURL(new URL(fetchURL), form);
            this.connection.throttle();
            updateMethod = this.createPostMethod(actionURL.toExternalForm(), this.actionArgs);
            int updateResponseCode = this.client.executeMethod((HttpMethod)updateMethod);
            String updateResponseBody = updateMethod.getResponseBodyAsString();
            StatusLine updateStatusLine = updateMethod.getStatusLine();
            this.debug((HttpMethod)updateMethod);
            URL redirect = null;
            if (updateResponseCode == 302) {
                redirect = this.extractRedirectURL((HttpMethod)updateMethod);
            }
            if (!(handled = this.responseSelect.handle(new ResponseData(updateStatusLine, updateResponseBody, redirect, actionURL)))) {
                this.logger.debug(updateResponseBody);
                throw new UnexpectedAnswerException("unexpected response data (FormAction)").addFactoid("status", updateStatusLine);
            }
        }
        catch (HttpException e) {
            throw new MethodException("method failed", e);
        }
        catch (IOException e) {
            throw new MethodException("method failed", e);
        }
        catch (InterruptedException e) {
            throw new MethodException("method aborted", e);
        }
        catch (IllegalFormException e) {
            throw new MethodException("method failed", e);
        }
        finally {
            if (fetchMethod != null) {
                fetchMethod.releaseConnection();
            }
            if (updateMethod != null) {
                updateMethod.releaseConnection();
            }
        }
    }
}

